/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.IRadiationModerator;
import erogenousbeef.bigreactors.common.BRRegistry;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.data.RadiationData;
import erogenousbeef.bigreactors.common.data.RadiationPacket;
import erogenousbeef.bigreactors.common.multiblock.helpers.FuelContainer;
import erogenousbeef.bigreactors.common.multiblock.helpers.ReactorInteriorData;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorControlRod;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.utils.StaticUtils;
import erogenousbeef.core.common.CoordTriplet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.oredict.OreDictionary;

public class RadiationHelper {
    public static final float fuelPerRadiationUnit = 7.0E-4f;
    public static final float rfPerRadiationUnit = 10.0f;
    public static final float fissionEventsPerFuelUnit = 0.01f;
    public static final ReactorInteriorData airData = new ReactorInteriorData(0.1f, 0.25f, 1.1f, 0.05f);
    public static final ReactorInteriorData waterData = new ReactorInteriorData(0.33f, 0.5f, 1.33f, 0.1f);
    private float fertility = 1.0f;

    public RadiationData radiate(World world, FuelContainer fuelContainer, TileEntityReactorFuelRod source, TileEntityReactorControlRod controlRod, float fuelHeat, float environmentHeat, int numControlRods) {
        if (fuelContainer.getFuelAmount() <= 0) {
            return null;
        }
        RadiationData data = new RadiationData();
        data.fuelAbsorbedRadiation = 0.0f;
        double radiationPenaltyBase = Math.exp(-15.0 * Math.exp(-0.0025 * (double)fuelHeat));
        int baseFuelAmount = fuelContainer.getFuelAmount() + fuelContainer.getWasteAmount() / 100;
        float fuelReactivity = fuelContainer.getFuelReactivity();
        float rawRadIntensity = (float)baseFuelAmount * 0.01f;
        float scaledRadIntensity = (float)Math.pow(rawRadIntensity, fuelReactivity);
        scaledRadIntensity = (float)Math.pow(scaledRadIntensity / (float)numControlRods, fuelReactivity) * (float)numControlRods;
        float controlRodModifier = (float)(100 - controlRod.getControlRodInsertion()) / 100.0f;
        float effectiveRadIntensity = (scaledRadIntensity *= controlRodModifier) * (1.0f + (float)((double)-0.95f * Math.exp(-10.0 * Math.exp(-0.0012f * fuelHeat))));
        float radHardness = 0.2f + (float)(0.8 * radiationPenaltyBase);
        float rawFuelUsage = 7.0E-4f * (rawRadIntensity *= controlRodModifier) / this.getFertilityModifier() * BigReactors.fuelUsageMultiplier;
        data.fuelRfChange = 10.0f * effectiveRadIntensity;
        data.environmentRfChange = 0.0f;
        CoordTriplet originCoord = source.getWorldLocation();
        CoordTriplet currentCoord = new CoordTriplet(0, 0, 0);
        effectiveRadIntensity *= 0.25f;
        RadiationPacket radPacket = new RadiationPacket();
        for (ForgeDirection dir : StaticUtils.CardinalDirections) {
            radPacket.hardness = radHardness;
            radPacket.intensity = effectiveRadIntensity;
            currentCoord.copy(originCoord);
            for (int ttl = 4; ttl > 0 && radPacket.intensity > 1.0E-4f; --ttl) {
                currentCoord.translate(dir);
                this.performIrradiation(world, data, radPacket, currentCoord.x, currentCoord.y, currentCoord.z);
            }
        }
        this.fertility += data.fuelAbsorbedRadiation;
        data.fuelAbsorbedRadiation = 0.0f;
        fuelContainer.onRadiationUsesFuel(rawFuelUsage);
        data.fuelUsage = rawFuelUsage;
        return data;
    }

    public void tick(boolean active) {
        float denominator = 20.0f;
        if (!active) {
            denominator *= 200.0f;
        }
        this.fertility = Math.max(0.0f, this.fertility - Math.max(0.1f, this.fertility / denominator));
    }

    private void performIrradiation(World world, RadiationData data, RadiationPacket radiation, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IRadiationModerator) {
            ((IRadiationModerator)te).moderateRadiation(data, radiation);
        } else if (world.func_72799_c(x, y, z)) {
            this.moderateByAir(data, radiation);
        } else {
            int blockID = world.func_72798_a(x, y, z);
            if (blockID > 0 && blockID < Block.field_71973_m.length) {
                Block b = Block.field_71973_m[blockID];
                if (b instanceof IFluidBlock) {
                    this.moderateByFluid(data, radiation, ((IFluidBlock)b).getFluid());
                } else {
                    this.moderateByBlock(data, radiation, blockID, world.func_72805_g(x, y, z));
                }
            } else {
                this.moderateByAir(data, radiation);
            }
        }
    }

    private void moderateByAir(RadiationData data, RadiationPacket radiation) {
        RadiationHelper.applyModerationFactors(data, radiation, airData);
    }

    private void moderateByBlock(RadiationData data, RadiationPacket radiation, int blockID, int metadata) {
        ReactorInteriorData moderatorData = null;
        if (blockID == Block.field_72083_ai.field_71990_ca) {
            moderatorData = BRRegistry.getReactorInteriorBlockData("blockIron");
        } else if (blockID == Block.field_72105_ah.field_71990_ca) {
            moderatorData = BRRegistry.getReactorInteriorBlockData("blockGold");
        } else if (blockID == Block.field_72071_ax.field_71990_ca) {
            moderatorData = BRRegistry.getReactorInteriorBlockData("blockDiamond");
        } else if (blockID == Block.field_72076_bV.field_71990_ca) {
            moderatorData = BRRegistry.getReactorInteriorBlockData("blockEmerald");
        } else {
            int oreId = OreDictionary.getOreID((ItemStack)new ItemStack(blockID, 1, metadata));
            if (oreId >= 0) {
                moderatorData = BRRegistry.getReactorInteriorBlockData(OreDictionary.getOreName((int)oreId));
            }
        }
        if (moderatorData == null) {
            moderatorData = airData;
        }
        RadiationHelper.applyModerationFactors(data, radiation, moderatorData);
    }

    private void moderateByFluid(RadiationData data, RadiationPacket radiation, Fluid fluid) {
        String name = fluid.getName();
        ReactorInteriorData moderatorData = BRRegistry.getReactorInteriorFluidData(fluid.getName());
        if (moderatorData == null) {
            moderatorData = waterData;
        }
        RadiationHelper.applyModerationFactors(data, radiation, moderatorData);
    }

    private static void applyModerationFactors(RadiationData data, RadiationPacket radiation, ReactorInteriorData moderatorData) {
        float radiationAbsorbed = radiation.intensity * moderatorData.absorption * (1.0f - radiation.hardness);
        radiation.intensity = Math.max(0.0f, radiation.intensity - radiationAbsorbed);
        radiation.hardness /= moderatorData.moderation;
        data.environmentRfChange += moderatorData.heatEfficiency * radiationAbsorbed * 10.0f;
    }

    public float getFertility() {
        return this.fertility;
    }

    public float getFertilityModifier() {
        if (this.fertility <= 1.0f) {
            return 1.0f;
        }
        return (float)(Math.log10(this.fertility) + 1.0);
    }

    public void setFertility(float newFertility) {
        this.fertility = Float.isNaN(newFertility) || Float.isInfinite(newFertility) ? 1.0f : (newFertility < 0.0f ? 0.0f : newFertility);
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("fertility")) {
            this.setFertility(data.func_74760_g("fertility"));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74776_a("fertility", this.fertility);
        return data;
    }

    public void merge(RadiationHelper other) {
        this.fertility = Math.max(this.fertility, other.fertility);
    }
}

