/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartStandard;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.network.Arguments;
import li.cil.oc.api.network.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraftforge.fluids.FluidTankInfo;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="OpenComputers"), @Optional.Interface(iface="dan200.computer.api.IPeripheral", modid="ComputerCraft")})
public class TileEntityTurbineComputerPort
extends TileEntityTurbinePartStandard
implements IPeripheral,
SimpleComponent,
ManagedPeripheral {
    public static final int numMethods;
    public static final String[] methodNames;
    public static final Map<String, Integer> methodIds;

    public Object[] callMethod(int method, Object[] arguments) throws Exception {
        if (method < 0 || method >= numMethods) {
            throw new IllegalArgumentException("Invalid method number");
        }
        if (method == 0) {
            return new Object[]{this.isConnected()};
        }
        if (!this.isConnected()) {
            throw new Exception("Unable to access turbine - port is not connected");
        }
        ComputerMethod computerMethod = ComputerMethod.values()[method];
        MultiblockTurbine turbine = this.getTurbine();
        switch (computerMethod) {
            case getConnected: {
                return new Object[]{this.isConnected()};
            }
            case getActive: {
                return new Object[]{turbine.isActive()};
            }
            case getEnergyProducedLastTick: {
                return new Object[]{Float.valueOf(turbine.getEnergyGeneratedLastTick())};
            }
            case getEnergyStored: {
                return new Object[]{Float.valueOf(turbine.getEnergyStored())};
            }
            case getFluidAmountMax: {
                return new Object[]{4000};
            }
            case getFluidFlowRate: {
                return new Object[]{turbine.getFluidConsumedLastTick()};
            }
            case getFluidFlowRateMax: {
                return new Object[]{turbine.getMaxIntakeRate()};
            }
            case getFluidFlowRateMaxMax: {
                return new Object[]{turbine.getMaxIntakeRateMax()};
            }
            case getInputAmount: {
                FluidTankInfo ti = turbine.getTankInfo(0);
                if (ti != null && ti.fluid != null) {
                    return new Object[]{ti.fluid.amount};
                }
                return new Object[]{Float.valueOf(0.0f)};
            }
            case getInputType: {
                FluidTankInfo ti = turbine.getTankInfo(0);
                if (ti != null && ti.fluid != null) {
                    return new Object[]{ti.fluid.getFluid().getName()};
                }
                return null;
            }
            case getOutputAmount: {
                FluidTankInfo ti = turbine.getTankInfo(1);
                if (ti != null && ti.fluid != null) {
                    return new Object[]{ti.fluid.amount};
                }
                return new Object[]{Float.valueOf(0.0f)};
            }
            case getOutputType: {
                FluidTankInfo ti = turbine.getTankInfo(1);
                if (ti != null && ti.fluid != null) {
                    return new Object[]{ti.fluid.getFluid().getName()};
                }
                return null;
            }
            case getRotorSpeed: {
                return new Object[]{Float.valueOf(turbine.getRotorSpeed())};
            }
            case getNumberOfBlades: {
                return new Object[]{turbine.getNumRotorBlades()};
            }
            case getBladeEfficiency: {
                return new Object[]{Float.valueOf(turbine.getRotorEfficiencyLastTick() * 100.0f)};
            }
            case getRotorMass: {
                return new Object[]{turbine.getRotorMass()};
            }
            case getInductorEngaged: {
                return new Object[]{turbine.getInductorEngaged()};
            }
            case setActive: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Boolean");
                }
                turbine.setActive((Boolean)arguments[0]);
                break;
            }
            case setFluidFlowRateMax: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Number");
                }
                int newRate = (int)Math.round((Double)arguments[0]);
                turbine.setMaxIntakeRate(newRate);
                break;
            }
            case setVentNone: {
                turbine.setVentStatus(MultiblockTurbine.VentStatus.DoNotVent, true);
                break;
            }
            case setVentOverflow: {
                turbine.setVentStatus(MultiblockTurbine.VentStatus.VentOverflow, true);
                break;
            }
            case setVentAll: {
                turbine.setVentStatus(MultiblockTurbine.VentStatus.VentAll, true);
                break;
            }
            case setInductorEngaged: {
                if (arguments.length < 1) {
                    throw new IllegalArgumentException("Insufficient number of arguments, expected 1");
                }
                if (!(arguments[0] instanceof Boolean)) {
                    throw new IllegalArgumentException("Invalid argument 0, expected Boolean");
                }
                turbine.setInductorEngaged((Boolean)arguments[0], true);
                break;
            }
            default: {
                throw new Exception("Method unimplemented - yell at Beef");
            }
        }
        return null;
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "BigReactors-Turbine";
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return methodNames;
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        return this.callMethod(method, arguments);
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "br_turbine";
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return methodNames;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        Object[] arguments = new Object[args.count()];
        for (int i = 0; i < args.count(); ++i) {
            arguments[i] = args.checkAny(i);
        }
        Integer methodId = methodIds.get(method);
        if (methodId == null) {
            throw new NoSuchMethodError();
        }
        return this.callMethod(methodId, arguments);
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this.hashCode() == other.hashCode();
    }

    static {
        ComputerMethod[] methods;
        numMethods = ComputerMethod.values().length;
        methodNames = new String[numMethods];
        for (ComputerMethod method : methods = ComputerMethod.values()) {
            TileEntityTurbineComputerPort.methodNames[method.ordinal()] = method.toString();
        }
        methodIds = new HashMap<String, Integer>();
        for (int i = 0; i < numMethods; ++i) {
            methodIds.put(methodNames[i], i);
        }
    }

    public static enum ComputerMethod {
        getConnected,
        getActive,
        getEnergyStored,
        getRotorSpeed,
        getInputAmount,
        getInputType,
        getOutputAmount,
        getOutputType,
        getFluidAmountMax,
        getFluidFlowRate,
        getFluidFlowRateMax,
        getFluidFlowRateMaxMax,
        getEnergyProducedLastTick,
        getNumberOfBlades,
        getBladeEfficiency,
        getRotorMass,
        getInductorEngaged,
        setActive,
        setFluidFlowRateMax,
        setVentNone,
        setVentOverflow,
        setVentAll,
        setInductorEngaged;

    }
}

