/*
 * Decompiled with CFR 0.152.
 */
package extracells.blocks;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.BlockEnum;
import extracells.Extracells;
import extracells.render.RenderHandler;
import extracells.tileentity.TileEntityCertusTank;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockCertusTank
extends BlockContainer {
    Icon breakIcon;
    Icon topIcon;
    Icon bottomIcon;
    Icon sideIcon;
    Icon sideMiddleIcon;
    Icon sideTopIcon;
    Icon sideBottomIcon;

    public BlockCertusTank(int id) {
        super(id, Material.field_76264_q);
        this.func_71849_a(Extracells.ModTab);
        this.func_71864_b("block.certustank");
        this.func_71848_c(2.0f);
        this.func_71894_b(10.0f);
        this.func_71905_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getDropWithNBT(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int b) {
        if (b == 1) {
            return this.sideTopIcon;
        }
        if (b == 2) {
            return this.sideBottomIcon;
        }
        if (b == 3) {
            return this.sideMiddleIcon;
        }
        return side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.sideIcon);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconregister) {
        this.breakIcon = iconregister.func_94245_a("extracells:certustank");
        this.topIcon = iconregister.func_94245_a("extracells:CTankTop");
        this.bottomIcon = iconregister.func_94245_a("extracells:CTankBottom");
        this.sideIcon = iconregister.func_94245_a("extracells:CTankSide");
        this.sideMiddleIcon = iconregister.func_94245_a("extracells:CTankSideMiddle");
        this.sideTopIcon = iconregister.func_94245_a("extracells:CTankSideTop");
        this.sideBottomIcon = iconregister.func_94245_a("extracells:CTankSideBottom");
    }

    public boolean canRenderInPass(int pass) {
        RenderHandler.renderPass = pass;
        return true;
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean func_71903_a(World worldObj, int x, int y, int z, EntityPlayer entityplayer, int blockID, float offsetX, float offsetY, float offsetZ) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (entityplayer.func_70093_af() && current == null) {
            this.func_71929_a(worldObj, x, y, z, this.getDropWithNBT(worldObj, x, y, z));
            worldObj.func_94578_a(x, y, z, false);
            return true;
        }
        if (current != null) {
            ItemStack filled;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            TileEntityCertusTank tank = (TileEntityCertusTank)worldObj.func_72796_p(x, y, z);
            if (liquid != null) {
                int amountFilled = tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                if (amountFilled != 0 && !entityplayer.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a > 1) {
                        --entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c].field_77994_a;
                        entityplayer.field_71071_by.func_70441_a(current.func_77973_b().getContainerItemStack(current));
                    } else {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = current.func_77973_b().getContainerItemStack(current);
                    }
                }
                return true;
            }
            FluidStack available = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a > 1) {
                        if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                            tank.fill(ForgeDirection.UNKNOWN, new FluidStack(liquid, liquid.amount), true);
                            return false;
                        }
                        --entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c].field_77994_a;
                    } else {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = filled;
                    }
                }
                tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public ItemStack getDropWithNBT(World world, int x, int y, int z) {
        NBTTagCompound tileEntity = new NBTTagCompound();
        TileEntity worldTE = world.func_72796_p(x, y, z);
        if (worldTE != null && worldTE instanceof TileEntityCertusTank) {
            ItemStack dropStack = new ItemStack(BlockEnum.CERTUSTANK.getBlockInstance(), 1);
            ((TileEntityCertusTank)worldTE).writeToNBTWithoutCoords(tileEntity);
            dropStack.func_77982_d(new NBTTagCompound());
            dropStack.field_77990_d.func_74766_a("tileEntity", tileEntity);
            return dropStack;
        }
        return null;
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityCertusTank();
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return Extracells.renderID;
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int neighbourID) {
        if (!world.field_72995_K) {
            PacketDispatcher.sendPacketToAllPlayers((Packet)world.func_72796_p(x, y, z).func_70319_e());
        }
    }
}

