/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.exnihilo.action;

import exnihilo.registries.CompostRegistry;
import exnihilo.registries.helpers.Compostable;
import java.util.Map;
import modtweaker.util.ItemHelper;
import net.minecraft.item.ItemStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItemStack;

public class CompostRemoveRecipeAction
implements IUndoableAction {
    private final TweakerItemStack result;
    private Compostable recipe;

    public CompostRemoveRecipeAction(TweakerItemStack output) {
        this.result = output;
    }

    public void apply() {
        for (Map.Entry registry : CompostRegistry.entries.entrySet()) {
            Compostable r = (Compostable)registry.getValue();
            if (!ItemHelper.areEqual(this.result.get(), new ItemStack(r.id, 1, r.meta))) continue;
            this.recipe = r;
            break;
        }
        if (this.recipe != null) {
            CompostRegistry.entries.remove(this.recipe.id + ":" + this.recipe.meta);
        }
    }

    public boolean canUndo() {
        return CompostRegistry.entries != null;
    }

    public void undo() {
        CompostRegistry.entries.put(this.recipe.id + ":" + this.recipe.meta, this.recipe);
    }

    public String describe() {
        return "Removing Compostable: " + this.result.getDisplayName();
    }

    public String describeUndo() {
        return "Restoring Compostable: " + this.result.getDisplayName();
    }
}

