/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mekanism;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import modtweaker.mekanism.TweakerGas;
import modtweaker.mekanism.TweakerGasBase;
import modtweaker.mekanism.TweakerGasStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerValue;

public class GasGroupValue
extends TweakerGasBase {
    private final String name;

    public GasGroupValue() {
        this.name = null;
    }

    public GasGroupValue(String name) {
        this.name = name;
    }

    public TweakerValue mul(TweakerValue value) throws TweakerExecuteException {
        Gas gas = GasRegistry.getGas((String)this.name);
        if (gas == null) {
            return super.mul(value);
        }
        return new TweakerGas(gas).mul(value);
    }

    @Override
    public TweakerGas asGas() {
        Gas gas = GasRegistry.getGas((String)this.name);
        if (gas == null) {
            return null;
        }
        return new TweakerGas(gas);
    }

    @Override
    public TweakerGasStack asGasStack() {
        Gas gas = GasRegistry.getGas((String)this.name);
        if (gas == null) {
            return null;
        }
        return new TweakerGasStack(new GasStack(gas, 1));
    }

    public TweakerValue index(String index) throws TweakerExecuteException {
        if (GasRegistry.containsGas((String)index)) {
            return new GasGroupValue(index);
        }
        if (GasRegistry.getGas((String)index) != null) {
            return new TweakerGas(GasRegistry.getGas((String)index));
        }
        if (GasRegistry.getGas((String)index) != null) {
            return new TweakerGas(GasRegistry.getGas((String)this.name)).index(index);
        }
        throw new TweakerExecuteException("no such gas: " + index);
    }

    public void indexSet(TweakerValue index, TweakerValue value) throws TweakerExecuteException {
        Fluid fluid = FluidRegistry.getFluid((String)this.name);
        if (fluid == null) {
            super.indexSet(index, value);
        } else {
            new TweakerLiquid(fluid).indexSet(index, value);
        }
    }

    @Override
    public String toString() {
        return this.name == null ? "fluids" : this.name;
    }
}

