/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.thermalexpansion;

import cofh.util.inventory.ComparableItemStackSafe;
import modtweaker.thermalexpansion.TEHacks;
import modtweaker.thermalexpansion.TEHelper;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;
import thermalexpansion.util.crafting.CrucibleManager;

public class CrucibleAddRecipe
extends TweakerBaseFunction {
    public static final CrucibleAddRecipe INSTANCE = new CrucibleAddRecipe();

    private CrucibleAddRecipe() {
        super("thermalexpansion.crucible.addRecipe");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(3, args)) {
            ItemStack input = TweakerHelper.getItem();
            FluidStack output = TweakerHelper.getFluid();
            int energy = TweakerHelper.getInt();
            Tweaker.apply((IUndoableAction)new Action(new ComparableItemStackSafe(input), TEHelper.getCrucibleRecipe(input, output, energy)));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 3);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final ComparableItemStackSafe key;
        private final CrucibleManager.RecipeCrucible recipe;

        public Action(ComparableItemStackSafe key, CrucibleManager.RecipeCrucible recipe) {
            this.key = key;
            this.recipe = recipe;
        }

        public void apply() {
            TEHacks.crucible.put(this.key, this.recipe);
        }

        public boolean canUndo() {
            return TEHacks.crucible != null;
        }

        public void undo() {
            TEHacks.crucible.remove(this.key);
        }

        public String describe() {
            return "Adding TE Crucible Recipe: " + this.recipe.getInput().func_82833_r() + " to " + this.recipe.getOutput().getFluid().getName();
        }

        public String describeUndo() {
            return "Removing TE Crucible Recipe: " + this.recipe.getInput().func_82833_r() + " to " + this.recipe.getOutput().getFluid().getName();
        }
    }
}

