/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.zip.CRC32;
import net.minecraft.server.MinecraftServer;
import stanhebben.minetweaker.GuiCannotRemodify;
import stanhebben.minetweaker.MineTweakerCommand;
import stanhebben.minetweaker.MineTweakerRegistry;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.TweakerConnectionHandler;
import stanhebben.minetweaker.TweakerPacketHandler;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.MineTweakerInterface;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerItemPattern;
import stanhebben.minetweaker.api.value.TweakerItemStackPattern;
import stanhebben.minetweaker.api.value.TweakerTable;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.base.actions.ServerAction;
import stanhebben.minetweaker.base.functions.FurnaceRemove;
import stanhebben.minetweaker.base.functions.MaxFunction;
import stanhebben.minetweaker.base.functions.MinFunction;
import stanhebben.minetweaker.base.functions.PrintFunction;
import stanhebben.minetweaker.base.functions.RemoveRecipesFunction;
import stanhebben.minetweaker.base.values.BlockGroupValue;
import stanhebben.minetweaker.base.values.FluidGroupValue;
import stanhebben.minetweaker.base.values.FurnaceValue;
import stanhebben.minetweaker.base.values.ItemGroupValue;
import stanhebben.minetweaker.base.values.MineTweakerValue;
import stanhebben.minetweaker.base.values.OreDictValue;
import stanhebben.minetweaker.base.values.RecipesValue;
import stanhebben.minetweaker.mods.buildcraft.BuildCraftModSupport;
import stanhebben.minetweaker.mods.forestry.ForestrySupport;
import stanhebben.minetweaker.mods.gregtech.GregTechModSupport;
import stanhebben.minetweaker.mods.ic2.IC2ModSupport;
import stanhebben.minetweaker.mods.mfr.MFRModSupport;
import stanhebben.minetweaker.mods.te.ThermalExpansionSupport;
import stanhebben.minetweaker.rewriter.ScriptRewriter;
import stanhebben.minetweaker.script.ScriptEnvironment;
import stanhebben.minetweaker.script.ScriptEnvironmentDir;
import stanhebben.minetweaker.script.ScriptEnvironmentVirtual;
import stanhebben.minetweaker.script.TweakerFile;
import stanhebben.minetweaker.script.parser.ParseException;
import stanhebben.minetweaker.tweaker.FuelTweaker;
import stanhebben.minetweaker.util.DataArrayInputStream;
import stanhebben.minetweaker.util.DataArrayOutputStream;
import stanhebben.minetweaker.util.DefaultUndoStack;
import stanhebben.minetweaker.util.IOUtil;

@Mod(modid="MineTweaker", name="MineTweaker", version="1.6.4-2.1.2")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, channels={"MTServerScript"}, packetHandler=TweakerPacketHandler.class)
public class MineTweaker {
    public static final String MCVERSION = "1.6.4";
    @Mod.Instance(value="MineTweaker")
    public static MineTweaker instance;
    private DefaultUndoStack undoStack;
    private final TweakerNameSpace global;
    private final List<MineTweakerInterface> interfaces;
    private final List<MineTweakerInterface> supportInterfaces;
    private final TweakerTable mods = new TweakerTable();
    private final TweakerTable modSupport = new TweakerTable();
    private File tweakerDir;
    private File mainFile;
    private byte[] serverScriptBytes;
    private boolean canClear = true;
    private boolean canRollback = true;
    private boolean iAmTheServer = false;
    private boolean serverMode = false;
    private int serverClearLevel = 0;
    private SocketAddress serverAddress = null;
    private long serverScriptHash = 0L;
    private byte[] serverScript = null;
    private String[] admins = new String[0];
    private final List<String> errorMessages = new ArrayList<String>();
    private final Map<cm, ez> adminHandlers = new HashMap<cm, ez>();

    public MineTweaker() {
        this.undoStack = new DefaultUndoStack();
        this.interfaces = new ArrayList<MineTweakerInterface>();
        this.supportInterfaces = new ArrayList<MineTweakerInterface>();
        this.global = new TweakerNameSpace(null);
        this.global.put("minetweaker", MineTweakerValue.INSTANCE);
        this.global.put("recipes", RecipesValue.INSTANCE);
        this.global.put("furnace", FurnaceValue.INSTANCE);
        this.global.put("oreDict", OreDictValue.INSTANCE);
        this.global.put("mods", this.mods);
        this.global.put("modSupport", this.modSupport);
        this.global.put("min", MinFunction.INSTANCE);
        this.global.put("max", MaxFunction.INSTANCE);
        this.global.put("print", PrintFunction.INSTANCE);
        this.global.put("tile", new BlockGroupValue("tile"));
        this.global.put("blocks", new BlockGroupValue());
        this.global.put("item", new ItemGroupValue("item"));
        this.global.put("items", new ItemGroupValue());
        this.global.put("fluid", new FluidGroupValue("fluid"));
        this.global.put("fluids", new FluidGroupValue());
    }

    public String[] getAdmins() {
        return this.admins;
    }

    public void setAdmins(String[] admins) {
        this.admins = admins;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void onAdminLogin(cm mgr, ez handler) {
        this.adminHandlers.put(mgr, handler);
    }

    public void onLogout(cm mgr) {
        this.adminHandlers.remove(mgr);
    }

    public void apply(IUndoableAction action) {
        if (this.canClear && !action.canUndo()) {
            Tweaker.log(Level.WARNING, "This action is not undoable: " + action.describe());
        }
        this.canClear &= action.canUndo();
        if (this.serverMode) {
            this.canRollback &= action.canUndo();
        }
        Tweaker.log(Level.INFO, action.describe());
        action.apply();
        this.undoStack.push(action);
    }

    public void registerModInterface(MineTweakerInterface iface) {
        this.interfaces.add(iface);
        this.mods.indexSet(iface.getName(), iface.getValue());
        Tweaker.log(Level.INFO, "Loaded mod interface: " + iface.getName());
    }

    public void registerSupportInterface(MineTweakerInterface iface) {
        this.supportInterfaces.add(iface);
        this.modSupport.indexSet(iface.getName(), iface.getValue());
    }

    public DefaultUndoStack clear() {
        if (this.serverMode) {
            ++this.serverClearLevel;
        }
        DefaultUndoStack old = this.undoStack;
        old.disable();
        this.undoStack = new DefaultUndoStack();
        return old;
    }

    public void undoClear(DefaultUndoStack old) {
        this.undoStack = old;
        old.enable();
        if (this.serverMode) {
            --this.serverClearLevel;
        }
    }

    public void reloadScripts() {
        MinecraftServer server = MinecraftServer.F();
        this.serverScriptBytes = this.getServerScripts(server);
        Tweaker.apply(new ServerAction(new InetSocketAddress("myself", 0), this.serverScriptBytes));
        this.errorMessages.clear();
        ea packet = instance.getServerScript() != null ? new ea("MTServerScript", instance.getServerScript()) : new ea("MTServerScript", new byte[0]);
        PacketDispatcher.sendPacketToAllPlayers((ey)packet);
    }

    public void signalServerStart(final SocketAddress address, byte[] serverScripts) {
        long crc = 0L;
        if (serverScripts != null) {
            CRC32 crc32 = new CRC32();
            crc32.update(serverScripts);
            crc = crc32.getValue();
        }
        if (this.serverAddress == null || !address.equals(this.serverAddress) || this.serverScriptHash != crc) {
            if (this.serverMode) {
                if (!this.canRollback) {
                    Tweaker.log(Level.INFO, "Cannot rollback, time to restart buddy!");
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (MineTweaker.this.serverAddress != null && address.equals(MineTweaker.this.serverAddress)) {
                                atv.w().a((awe)new GuiCannotRemodify("Minecraft has been tweaked for another server", "with modifications that cannot be rolled back.", "Please restart your game."));
                            } else {
                                atv.w().a((awe)new GuiCannotRemodify("This server's script has changed and the modifications", "of the old script cannot be rolled back.", "Please restart your game."));
                            }
                        }
                    }, 1000L);
                } else {
                    while (this.serverMode) {
                        IUndoableAction action = this.undoStack.pop();
                        Tweaker.log(Level.INFO, action.describeUndo());
                        action.undo();
                    }
                }
            }
            try {
                this.serverMode = true;
                this.serverAddress = address;
                this.serverScriptHash = crc;
                this.serverScript = serverScripts;
                if (serverScripts != null) {
                    DataArrayInputStream input = new DataArrayInputStream(serverScripts);
                    int numFiles = input.readInt();
                    HashMap<String, String> files = new HashMap<String, String>();
                    for (int i = 0; i < numFiles; ++i) {
                        String name = input.readUTF();
                        String content = input.readUTF();
                        files.put(name, content);
                    }
                    ScriptEnvironmentVirtual env = new ScriptEnvironmentVirtual(files);
                    int numActionsBefore = this.undoStack.size();
                    env.getFile("/main.cfg").execute(new TweakerNameSpace(this.global));
                    Tweaker.log(Level.INFO, "Server script executed: " + (this.undoStack.size() - numActionsBefore) + " alterations");
                }
            }
            catch (TweakerException ex) {
                this.onError(ex.getFile().getName() + ":" + ex.getLine() + " " + ex.getExplanation());
            }
            catch (ParseException ex) {
                this.onError(ex.getFile() + ":" + ex.getLine() + " " + ex.getExplanation());
            }
            catch (Exception ex) {
                this.onError("Exception: " + ex.getMessage());
            }
        }
    }

    public void signalServerEnd() {
        if (this.serverClearLevel == 0) {
            this.serverMode = false;
        }
    }

    public int remove(TweakerItemStackPattern item) {
        int total = 0;
        total += RemoveRecipesFunction.INSTANCE.remove(item);
        total += FurnaceRemove.INSTANCE.remove(item);
        for (MineTweakerInterface iface : this.interfaces) {
            total += iface.remove(item);
        }
        for (MineTweakerInterface iface : this.supportInterfaces) {
            total += iface.remove(item);
        }
        return total;
    }

    public int replace(TweakerItemPattern original, TweakerValue replaced) {
        return 0;
    }

    public void serverExecute(SocketAddress from, byte[] serverScripts) {
        if (this.iAmTheServer) {
            Tweaker.log(Level.INFO, "Skipping local server script");
            return;
        }
        if (Tweaker.isLoggable(Level.FINEST)) {
            this.global.printContents();
        }
        Tweaker.apply(new ServerAction(from, serverScripts));
    }

    public byte[] getServerScript() {
        return this.serverScriptBytes;
    }

    public boolean canClear() {
        return this.canClear;
    }

    public boolean canRollback() {
        return this.canRollback;
    }

    public TweakerNameSpace getGlobal() {
        return this.global;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Tweaker.onInit();
        File configFile = event.getSuggestedConfigurationFile();
        this.tweakerDir = new File(configFile.getParentFile(), "minetweaker");
        this.mainFile = new File(this.tweakerDir, "main.cfg");
        if (!this.tweakerDir.exists()) {
            this.tweakerDir.mkdir();
            if (configFile.exists()) {
                ScriptRewriter.rewrite(configFile, this.mainFile);
            } else {
                try {
                    this.mainFile.createNewFile();
                    FileWriter w = new FileWriter(this.mainFile);
                    w.write("# See the forum post for example and documentation.\r\n");
                    w.write("version 2;\r\n");
                    w.write("\r\n");
                    w.write("# set your list of server admin usernames here\r\n");
                    w.write("# admins are privileged users and will receive\r\n");
                    w.write("# any error messages that might occur.\r\n");
                    w.write("minetweaker.setAdmins(\"Myself\", \"MyAdminBuddy\");\r\n");
                    w.write("\r\n");
                    w.write("# Add your commands here\r\n");
                    ((Writer)w).close();
                }
                catch (IOException ex) {
                    this.onError("Could not create script file", ex);
                }
            }
        }
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new TweakerConnectionHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MineTweakerRegistry.INSTANCE.init();
        FuelTweaker.INSTANCE.register();
        for (ModContainer mod : Loader.instance().getModList()) {
            System.out.println("Found mod: " + mod.getModId());
        }
        if (ModLoader.isModLoaded((String)"BuildCraft|Core")) {
            this.registerSupportInterface(BuildCraftModSupport.INSTANCE);
            Tweaker.log(Level.INFO, "BuildCraft support loaded");
        }
        if (ModLoader.isModLoaded((String)"IC2")) {
            this.registerSupportInterface(IC2ModSupport.INSTANCE);
            Tweaker.log(Level.INFO, "IC2 support loaded");
        }
        if (ModLoader.isModLoaded((String)"gregtech_addon")) {
            this.registerSupportInterface(GregTechModSupport.INSTANCE);
            Tweaker.log(Level.INFO, "GregTech support loaded");
        }
        if (ModLoader.isModLoaded((String)"Forestry")) {
            this.registerSupportInterface(ForestrySupport.INSTANCE);
            Tweaker.log(Level.INFO, "Forestry support loaded");
        }
        if (ModLoader.isModLoaded((String)"MineFactoryReloaded")) {
            this.registerSupportInterface(MFRModSupport.INSTANCE);
            Tweaker.log(Level.INFO, "MineFactory Reloaded support loaded");
        }
        if (ModLoader.isModLoaded((String)"ThermalExpansion")) {
            this.registerSupportInterface(ThermalExpansionSupport.INSTANCE);
            Tweaker.log(Level.INFO, "Thermal Expansion support loaded");
        }
        try {
            ScriptEnvironmentDir environment = new ScriptEnvironmentDir(this.tweakerDir);
            TweakerFile bootScript = new TweakerFile((ScriptEnvironment)environment, "/" + this.mainFile.getName(), this.mainFile);
            bootScript.execute(new TweakerNameSpace(this.global));
        }
        catch (IOException ex) {
            this.onError("Could not read script file: " + ex.getMessage(), ex);
        }
        catch (ParseException ex) {
            this.onError(ex.getFile() + ":" + ex.getLine() + " " + ex.getExplanation());
        }
        catch (TweakerException ex) {
            this.onError(ex.getFile().getName() + ":" + ex.getLine() + ex.getExplanation());
        }
        catch (Exception ex) {
            this.onError("Could not process scipts", ex);
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ab)new MineTweakerCommand());
        this.serverScriptBytes = this.getServerScripts(event.getServer());
        this.iAmTheServer = true;
        Tweaker.apply(new ServerAction(new InetSocketAddress("myself", 0), this.serverScriptBytes));
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent ev) {
        this.iAmTheServer = false;
        this.serverScriptBytes = null;
    }

    private void collectServerScripts(File serverDir, HashMap<String, File> files) {
        this.collectServerScripts("/", serverDir, files);
    }

    private void collectServerScripts(String dir, File fdir, HashMap<String, File> files) {
        for (File f : fdir.listFiles()) {
            if (f.isDirectory()) {
                this.collectServerScripts(dir + f.getName() + "/", f, files);
                continue;
            }
            if (!f.isFile()) continue;
            files.put(dir + f.getName(), f);
        }
    }

    private byte[] getServerScripts(MinecraftServer server) {
        File saveDir = MineTweakerUtil.getWorldDirectory(server);
        Tweaker.log(Level.FINE, "World dir: " + saveDir.getAbsolutePath());
        File serverScriptDir = new File(saveDir, "minetweaker");
        if (serverScriptDir.exists() && new File(serverScriptDir, "main.cfg").exists()) {
            HashMap<String, File> serverScripts = new HashMap<String, File>();
            this.collectServerScripts(serverScriptDir, serverScripts);
            DataArrayOutputStream output = new DataArrayOutputStream();
            output.writeInt(serverScripts.size());
            for (String name : serverScripts.keySet()) {
                String contents = IOUtil.readFileAsString(serverScripts.get(name));
                if (contents == null) continue;
                output.writeUTF(name);
                output.writeUTF(contents);
            }
            return output.toByteArray();
        }
        return null;
    }

    private void onError(String message) {
        this.onError(message, null);
    }

    private void onError(String message, Exception ex) {
        Tweaker.log(Level.SEVERE, message, ex);
        this.errorMessages.add(message);
        for (Map.Entry<cm, ez> entry : this.adminHandlers.entrySet()) {
            entry.getValue().getPlayer().a(cv.d((String)message));
        }
    }
}

