/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import java.util.Arrays;
import java.util.Iterator;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerArrayBytes;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerValue;

public class TweakerArrayInts
extends TweakerArray {
    private int[] data;
    private int size;

    public TweakerArrayInts() {
        this.data = new int[16];
        this.size = 0;
    }

    public TweakerArrayInts(int[] data) {
        this.size = data.length;
        if (data.length < 16) {
            data = Arrays.copyOf(data, 16);
        }
        this.data = data;
    }

    public void addInt(int value) {
        if (this.size == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        this.data[this.size++] = value;
    }

    public void addInt(int index, int value) {
        if (this.size == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        for (int i = this.size; i > index; --i) {
            this.data[i] = this.data[i - 1];
        }
        this.data[index] = value;
    }

    public int getInt(int index) {
        return this.data[index];
    }

    public int removeInt(int index) {
        int result = this.data[index];
        --this.size;
        for (int i = index; i < this.size; ++i) {
            this.data[i] = this.data[i + 1];
        }
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TweakerValue get(int index) {
        return new TweakerInt(this.data[index]);
    }

    @Override
    public TweakerValue remove(int index) {
        return new TweakerInt(this.removeInt(index));
    }

    @Override
    public TweakerValue addAssign(TweakerValue value) {
        if (value == null) {
            throw new TweakerExecuteException("Cannot convert a null value to an int");
        }
        this.addInt(value.toInt("cannot convert this value to int").get());
        return this;
    }

    @Override
    public TweakerValue subAssign(TweakerValue value) {
        if (value == null) {
            throw new TweakerExecuteException("Cannot convert a null value to an int");
        }
        int ivalue = value.toInt("cannot convert this value to int").get();
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != ivalue) continue;
            this.removeInt(i);
            return this;
        }
        return this;
    }

    @Override
    public Iterator<TweakerValue> iterator() {
        return new Iterator<TweakerValue>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < TweakerArrayInts.this.size;
            }

            @Override
            public TweakerValue next() {
                return new TweakerInt(TweakerArrayInts.this.data[this.i++]);
            }

            @Override
            public void remove() {
                --this.i;
                TweakerArrayInts.this.removeInt(this.i);
            }
        };
    }

    @Override
    public TweakerArrayBytes asByteArray() {
        byte[] data = new byte[this.size];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)this.data[i];
        }
        return new TweakerArrayBytes(data);
    }

    @Override
    public TweakerArrayInts asIntArray() {
        return this;
    }

    @Override
    public TweakerValue index(String index) {
        if (index == null) {
            throw new TweakerExecuteException("Cannot index an int array with a null value");
        }
        if (index.equals("copy")) {
            return new TweakerArrayInts(Arrays.copyOf(this.data, this.size));
        }
        return super.index(index);
    }

    @Override
    public cl toTagValue(String name) {
        return new ce(name, this.size < this.data.length ? Arrays.copyOf(this.data, this.size) : this.data);
    }
}

