/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerBool;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerDouble;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerLong;
import stanhebben.minetweaker.api.value.TweakerShort;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;

public final class TweakerFloat
extends TweakerValue {
    private final float value;

    public TweakerFloat(float value) {
        this.value = value;
    }

    public float get() {
        return this.value;
    }

    @Override
    public TweakerByte asByte() {
        if (this.value < -128.0f || this.value > 127.0f) {
            return null;
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerByte toByte(String error) {
        if (this.value < -128.0f || this.value > 127.0f) {
            throw new TweakerExecuteException("Value out of byte range, cannot convert: " + this.value);
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerShort asShort() {
        if (this.value < -32768.0f || this.value > 32767.0f) {
            return null;
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerShort toShort(String error) {
        if (this.value < -32768.0f || this.value > 32767.0f) {
            throw new TweakerExecuteException("Value out of short range, cannot convert: " + this.value);
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerInt asInt() {
        if (this.value < -2.1474836E9f || this.value > 2.1474836E9f) {
            return null;
        }
        return new TweakerInt((int)this.value);
    }

    @Override
    public TweakerInt toInt(String message) {
        if (this.value < -2.1474836E9f || this.value > 2.1474836E9f) {
            throw new TweakerExecuteException("Value out of integer range, cannot convert: " + this.value);
        }
        return new TweakerInt((int)this.value);
    }

    @Override
    public TweakerLong asLong() {
        if (this.value < -9.223372E18f || this.value > 9.223372E18f) {
            return null;
        }
        return new TweakerLong((long)this.value);
    }

    @Override
    public TweakerLong toLong(String error) {
        if (this.value < -9.223372E18f || this.value > 9.223372E18f) {
            throw new TweakerExecuteException("Value out of long range, cannot convert: " + this.value);
        }
        return new TweakerLong((long)this.value);
    }

    @Override
    public TweakerFloat asFloat() throws TweakerExecuteException {
        return this;
    }

    @Override
    public TweakerDouble asDouble() throws TweakerExecuteException {
        return new TweakerDouble(this.value);
    }

    @Override
    public TweakerString asString() {
        return new TweakerString(Float.toString(this.value));
    }

    @Override
    public cl toTagValue(String name) {
        return new cd(name, this.value);
    }

    @Override
    public TweakerValue add(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot add null to a float value");
        }
        return other.addToFloat(this.value);
    }

    @Override
    public TweakerValue sub(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot subtract null from a float value");
        }
        return other.subToFloat(this.value);
    }

    @Override
    public TweakerValue mul(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot multiply a float value by null");
        }
        return other.mulToFloat(this.value);
    }

    @Override
    public TweakerValue div(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot divide a float value by null");
        }
        return other.divToFloat(this.value);
    }

    @Override
    public TweakerValue mod(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot modulo a float value with null");
        }
        return other.modToFloat(this.value);
    }

    @Override
    public TweakerValue neg() {
        return new TweakerFloat(-this.value);
    }

    @Override
    public boolean equals(TweakerValue other) {
        if (other == null) {
            return false;
        }
        return other.equalsFloat(this.value);
    }

    @Override
    public int compare(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot compare a float value with null");
        }
        return other.compareFloat(this.value);
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case ABS: {
                return new TweakerFloat(Math.abs(this.value));
            }
            case ISNAN: {
                return TweakerBool.get(Float.isNaN(this.value));
            }
            case ISINFINITE: {
                return TweakerBool.get(Float.isInfinite(this.value));
            }
        }
        throw new TweakerExecuteException("Unknown member " + index + " of float value");
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public TweakerValue addToInt(int value) {
        return new TweakerFloat(this.value + (float)value);
    }

    @Override
    public TweakerValue addToLong(long value) {
        return new TweakerFloat(this.value + (float)value);
    }

    @Override
    public TweakerValue addToFloat(float value) {
        return new TweakerFloat(value + this.value);
    }

    @Override
    public TweakerValue addToDouble(double value) {
        return new TweakerDouble(value + (double)this.value);
    }

    @Override
    public TweakerValue subToInt(int value) {
        return new TweakerFloat((float)value - this.value);
    }

    @Override
    public TweakerValue subToLong(long value) {
        return new TweakerFloat((float)value - this.value);
    }

    @Override
    public TweakerValue subToFloat(float value) {
        return new TweakerFloat(value - this.value);
    }

    @Override
    public TweakerValue subToDouble(double value) {
        return new TweakerDouble(value - (double)this.value);
    }

    @Override
    public TweakerValue mulToInt(int value) {
        return new TweakerFloat((float)value * this.value);
    }

    @Override
    public TweakerValue mulToLong(long value) {
        return new TweakerFloat((float)value * this.value);
    }

    @Override
    public TweakerValue mulToFloat(float value) {
        return new TweakerFloat(value * this.value);
    }

    @Override
    public TweakerValue mulToDouble(double value) {
        return new TweakerDouble(value * (double)this.value);
    }

    @Override
    public TweakerValue divToInt(int value) {
        return new TweakerFloat((float)value / this.value);
    }

    @Override
    public TweakerValue divToLong(long value) {
        return new TweakerFloat((float)value / this.value);
    }

    @Override
    public TweakerValue divToFloat(float value) {
        return new TweakerFloat(value / this.value);
    }

    @Override
    public TweakerValue divToDouble(double value) {
        return new TweakerDouble(value / (double)this.value);
    }

    @Override
    public TweakerValue modToInt(int value) {
        return new TweakerFloat((float)value % this.value);
    }

    @Override
    public TweakerValue modToLong(long value) {
        return new TweakerFloat((float)value % this.value);
    }

    @Override
    public TweakerValue modToFloat(float value) {
        return new TweakerFloat(value % this.value);
    }

    @Override
    public TweakerValue modToDouble(double value) {
        return new TweakerDouble(value % (double)this.value);
    }

    @Override
    public boolean equalsInt(int value) {
        return (double)Math.abs(this.value - (float)value) < 1.0E-5;
    }

    @Override
    public boolean equalsLong(long value) {
        return (double)Math.abs(this.value - (float)value) < 1.0E-5;
    }

    @Override
    public boolean equalsDouble(double value) {
        return Math.abs((double)this.value - value) < 1.0E-5;
    }

    @Override
    public int compareInt(int value) {
        if ((double)Math.abs(this.value - (float)value) < 1.0E-5) {
            return 0;
        }
        if (this.value > (float)value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareLong(long value) {
        if ((double)Math.abs(this.value - (float)value) < 1.0E-5) {
            return 0;
        }
        if (this.value > (float)value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareFloat(float value) {
        if ((double)Math.abs(this.value - value) < 1.0E-5) {
            return 0;
        }
        if (this.value > value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareDouble(double value) {
        if (Math.abs((double)this.value - value) < 1.0E-5) {
            return 0;
        }
        if ((double)this.value > value) {
            return 1;
        }
        return 0;
    }
}

