/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerBool;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerNBTCompound;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;

public final class TweakerLiquidStack
extends TweakerValue {
    private final FluidStack value;

    public static TweakerLiquidStack fromLiquidBlock(TweakerItem block) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid.getBlockID() != block.getItemId()) continue;
            return new TweakerLiquidStack(new FluidStack(fluid, 1));
        }
        return null;
    }

    public TweakerLiquidStack(FluidStack value) {
        this.value = value;
    }

    public FluidStack get() {
        return this.value;
    }

    public String getName() {
        return this.value.getFluid().getName();
    }

    public String getDisplayName() {
        return this.value.getFluid().getLocalizedName();
    }

    public TweakerLiquidStack fill(mo inventory, TweakerItem[] containers) {
        FluidStack remaining = new FluidStack(this.value.fluidID, this.value.amount);
        int size = inventory.j_();
        for (int i = 0; i < size; ++i) {
            ye stack = inventory.a(i);
            if (stack == null) continue;
            block1: for (TweakerItem container : containers) {
                ye filled;
                if (!container.matches(stack) || !FluidContainerRegistry.containsFluid((ye)stack, (FluidStack)this.value)) continue;
                while (stack.b > 0 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)remaining, (ye)stack)) != null) {
                    boolean stored = false;
                    int empty = -1;
                    for (int j = 0; j < size; ++j) {
                        ye stack2 = inventory.a(j);
                        if (stack2 != null) {
                            if (filled.d != stack2.d || filled.k() != stack2.k() || stack2.b >= stack2.e()) continue;
                            ++stack2.b;
                            stored = true;
                            continue;
                        }
                        if (empty >= 0) continue;
                        empty = j;
                    }
                    if (!stored) {
                        if (stack.b == 1) {
                            empty = i;
                        }
                        if (empty >= 0) {
                            inventory.a(empty, stack);
                            stored = true;
                        }
                    }
                    if (!stored) continue block1;
                    remaining.amount -= FluidContainerRegistry.getFluidForFilledItem((ye)filled).amount;
                }
            }
        }
        return new TweakerLiquidStack(remaining);
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case NAME: {
                return new TweakerString(this.value.getFluid().getUnlocalizedName());
            }
            case DISPLAYNAME: {
                return new TweakerString(this.value.getFluid().getLocalizedName());
            }
            case LUMINOSITY: {
                return new TweakerInt(this.value.getFluid().getLuminosity(this.value));
            }
            case DENSITY: {
                return new TweakerInt(this.value.getFluid().getDensity(this.value));
            }
            case TEMPERATURE: {
                return new TweakerInt(this.value.getFluid().getTemperature(this.value));
            }
            case GASEOUS: {
                return TweakerBool.get(this.value.getFluid().isGaseous(this.value));
            }
            case AMOUNT: {
                return new TweakerInt(this.value.amount);
            }
            case TAG: {
                return new TweakerNBTCompound(this.value.tag);
            }
            case FLUID: {
                return new TweakerLiquid(this.value.getFluid());
            }
        }
        throw new TweakerExecuteException("no such field in fluid: " + index);
    }

    @Override
    public TweakerLiquidStack asFluidStack() {
        return this;
    }

    @Override
    public String toString() {
        return "FluidStack:" + this.value.getFluid().getUnlocalizedName() + " * " + this.value.amount;
    }
}

