/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerDouble;
import stanhebben.minetweaker.api.value.TweakerFloat;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerShort;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;

public final class TweakerLong
extends TweakerValue {
    private final long value;

    public TweakerLong(long value) {
        this.value = value;
    }

    public long get() {
        return this.value;
    }

    @Override
    public long toBasicLong() {
        return this.value;
    }

    @Override
    public cl toTagValue(String name) {
        return new ch(name, this.value);
    }

    @Override
    public TweakerByte asByte() {
        if (this.value < -128L || this.value > 127L) {
            return null;
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerByte toByte(String error) {
        if (this.value < -128L || this.value > 127L) {
            throw new TweakerExecuteException("Value outside byte range, cannot convert: " + this.value);
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerShort asShort() {
        if (this.value < -32768L || this.value > 32767L) {
            return null;
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerShort toShort(String error) {
        if (this.value < -32768L || this.value > 32767L) {
            throw new TweakerExecuteException("Value outside short range, cannot convert: " + this.value);
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerInt asInt() {
        if (this.value < Integer.MIN_VALUE || this.value > Integer.MAX_VALUE) {
            return null;
        }
        return new TweakerInt((int)this.value);
    }

    @Override
    public TweakerInt toInt(String error) {
        if (this.value < Integer.MIN_VALUE || this.value > Integer.MAX_VALUE) {
            throw new TweakerExecuteException("Value outside int range, cannot convert: " + this.value);
        }
        return new TweakerInt((int)this.value);
    }

    @Override
    public TweakerLong asLong() {
        return this;
    }

    @Override
    public TweakerLong toLong(String error) {
        return this;
    }

    @Override
    public TweakerFloat asFloat() {
        return new TweakerFloat(this.value);
    }

    @Override
    public TweakerDouble asDouble() {
        return new TweakerDouble(this.value);
    }

    @Override
    public TweakerString asString() {
        return new TweakerString(Long.toString(this.value));
    }

    @Override
    public TweakerValue add(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot add null to a long value");
        }
        return other.addToLong(this.value);
    }

    @Override
    public TweakerValue sub(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot subtract null from a long value");
        }
        return other.subToLong(this.value);
    }

    @Override
    public TweakerValue mul(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot multiply a long value by null");
        }
        return other.mulToLong(this.value);
    }

    @Override
    public TweakerValue div(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot divide a long value by null");
        }
        return other.divToLong(this.value);
    }

    @Override
    public TweakerValue mod(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot modulo a long value by null");
        }
        return other.modToLong(this.value);
    }

    @Override
    public TweakerValue neg() {
        return new TweakerLong(-this.value);
    }

    @Override
    public TweakerValue not() {
        return new TweakerLong(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public TweakerValue or(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot or a long value with null");
        }
        return other.orToLong(this.value);
    }

    @Override
    public TweakerValue and(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot and a long value with null");
        }
        return other.andToLong(this.value);
    }

    @Override
    public TweakerValue xor(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot xor a long value with null");
        }
        return other.xorToLong(this.value);
    }

    @Override
    public boolean equals(TweakerValue other) {
        if (other == null) {
            return false;
        }
        return other.equalsLong(this.value);
    }

    @Override
    public int compare(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot compare a long value with null");
        }
        return other.compareLong(this.value);
    }

    @Override
    public TweakerValue index(String index) {
        if (index.equals("abs")) {
            return new TweakerLong(Math.abs(this.value));
        }
        throw new TweakerExecuteException("Unknown member " + index + " of byte value");
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public TweakerValue addToInt(int value) {
        return new TweakerLong(this.value + (long)value);
    }

    @Override
    public TweakerValue addToLong(long value) {
        return new TweakerLong(this.value + value);
    }

    @Override
    public TweakerValue addToFloat(float value) {
        return new TweakerFloat(value + (float)this.value);
    }

    @Override
    public TweakerValue addToDouble(double value) {
        return new TweakerDouble(value + (double)this.value);
    }

    @Override
    public TweakerValue subToInt(int value) {
        return new TweakerLong((long)value - this.value);
    }

    @Override
    public TweakerValue subToLong(long value) {
        return new TweakerLong(value - this.value);
    }

    @Override
    public TweakerValue subToFloat(float value) {
        return new TweakerFloat(value - (float)this.value);
    }

    @Override
    public TweakerValue subToDouble(double value) {
        return new TweakerDouble(value - (double)this.value);
    }

    @Override
    public TweakerValue mulToInt(int value) {
        return new TweakerLong((long)value * this.value);
    }

    @Override
    public TweakerValue mulToLong(long value) {
        return new TweakerLong(value * this.value);
    }

    @Override
    public TweakerValue mulToFloat(float value) {
        return new TweakerFloat(value * (float)this.value);
    }

    @Override
    public TweakerValue mulToDouble(double value) {
        return new TweakerDouble(value * (double)this.value);
    }

    @Override
    public TweakerValue divToInt(int value) {
        if (this.value == 0L) {
            throw new TweakerExecuteException("Cannot divide an int value by zero");
        }
        return new TweakerLong((long)value / this.value);
    }

    @Override
    public TweakerValue divToLong(long value) {
        if (this.value == 0L) {
            throw new TweakerExecuteException("Cannot divide a long value by zero");
        }
        return new TweakerLong(value / this.value);
    }

    @Override
    public TweakerValue divToFloat(float value) {
        return new TweakerFloat(value / (float)this.value);
    }

    @Override
    public TweakerValue divToDouble(double value) {
        return new TweakerDouble(value / (double)this.value);
    }

    @Override
    public TweakerValue modToInt(int value) {
        if (this.value == 0L) {
            throw new TweakerExecuteException("Cannot modulo an int value by zero");
        }
        return new TweakerLong((long)value % this.value);
    }

    @Override
    public TweakerValue modToLong(long value) {
        if (this.value == 0L) {
            throw new TweakerExecuteException("Cannot modulo a long value by zero");
        }
        return new TweakerLong(value % this.value);
    }

    @Override
    public TweakerValue modToFloat(float value) {
        return new TweakerFloat(value % (float)this.value);
    }

    @Override
    public TweakerValue modToDouble(double value) {
        return new TweakerDouble(value % (double)this.value);
    }

    @Override
    public TweakerValue orToByte(byte value) {
        return new TweakerLong((long)value | this.value);
    }

    @Override
    public TweakerValue orToShort(short value) {
        return new TweakerLong((long)value | this.value);
    }

    @Override
    public TweakerValue orToInt(int value) {
        return new TweakerLong((long)value | this.value);
    }

    @Override
    public TweakerValue orToLong(long value) {
        return new TweakerLong(value | this.value);
    }

    @Override
    public TweakerValue andToByte(byte value) {
        return new TweakerByte((byte)((long)value & this.value));
    }

    @Override
    public TweakerValue andToShort(short value) {
        return new TweakerShort((short)((long)value & this.value));
    }

    @Override
    public TweakerValue andToInt(int value) {
        return new TweakerInt((int)((long)value & this.value));
    }

    @Override
    public TweakerValue andToLong(long value) {
        return new TweakerLong(value & this.value);
    }

    @Override
    public TweakerValue xorToByte(byte value) {
        return new TweakerLong((long)value ^ this.value);
    }

    @Override
    public TweakerValue xorToShort(short value) {
        return new TweakerLong((long)value ^ this.value);
    }

    @Override
    public TweakerValue xorToInt(int value) {
        return new TweakerLong((long)value ^ this.value);
    }

    @Override
    public TweakerValue xorToLong(long value) {
        return new TweakerLong(value ^ this.value);
    }

    @Override
    public boolean equalsInt(int value) {
        return this.value == (long)value;
    }

    @Override
    public boolean equalsLong(long value) {
        return this.value == value;
    }

    @Override
    public boolean equalsFloat(float value) {
        return (double)Math.abs(value - (float)this.value) < 1.0E-5;
    }

    @Override
    public boolean equalsDouble(double value) {
        return Math.abs(value - (double)this.value) < 1.0E-5;
    }

    @Override
    public int compareInt(int value) {
        return Long.compare(value, this.value);
    }

    @Override
    public int compareLong(long value) {
        return Long.compare(value, this.value);
    }

    @Override
    public int compareFloat(float value) {
        if ((double)Math.abs(value - (float)this.value) < 1.0E-5) {
            return 0;
        }
        if (value > (float)this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareDouble(double value) {
        if (Math.abs(value - (double)this.value) < 1.0E-5) {
            return 0;
        }
        if (value > (double)this.value) {
            return 1;
        }
        return 0;
    }
}

