/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.common.MinecraftForge;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.api.IUndoableAction;

public class ItemRemoveToolAction
implements IUndoableAction {
    private final aqz block;
    private final int meta;
    private final String tool;
    private final boolean wasEffective;
    private final Integer oldLevel;

    public ItemRemoveToolAction(aqz block, int meta, String tool) {
        this.block = block;
        this.meta = meta;
        this.tool = tool;
        this.oldLevel = MineTweakerUtil.getBlockHarvestLevel(block, meta, tool);
        this.wasEffective = MineTweakerUtil.isHarvestEffective(block, meta, tool);
    }

    @Override
    public void apply() {
        MineTweakerUtil.removeBlockTool(this.block, this.meta, this.tool);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.wasEffective && this.oldLevel != null) {
            MinecraftForge.setBlockHarvestLevel((aqz)this.block, (int)this.meta, (String)this.tool, (int)this.oldLevel);
        }
    }

    @Override
    public String describe() {
        return "Removing tool class " + this.tool + " from block " + this.block.cF + ":" + this.meta;
    }

    @Override
    public String describeUndo() {
        return "Restoring tool class " + this.tool + " to block " + this.block.cF + ":" + this.meta;
    }
}

