/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import cpw.mods.fml.common.registry.LanguageRegistry;
import stanhebben.minetweaker.api.IUndoableAction;

public class SetLocalizedStringAction
implements IUndoableAction {
    private String key;
    private String lang;
    private String value;
    private String oldValue;

    public SetLocalizedStringAction(String key, String lang, String value) {
        this.key = key;
        this.lang = lang;
        this.value = value;
    }

    @Override
    public void apply() {
        this.oldValue = LanguageRegistry.instance().getStringLocalization(this.key, this.lang);
        LanguageRegistry.instance().addStringLocalization(this.key, this.lang, this.value);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        LanguageRegistry.instance().addStringLocalization(this.key, this.lang, this.oldValue);
    }

    @Override
    public String describe() {
        return "Setting the " + this.lang + " translation for " + this.key + " to " + this.value;
    }

    @Override
    public String describeUndo() {
        return "Restoring the " + this.lang + " translation for " + this.key + " to " + this.oldValue;
    }
}

