/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.functions;

import java.util.logging.Level;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.base.actions.RemoveLiquidContainerAction;

public class RemoveFluidContainerFunction
extends TweakerFunction {
    private Fluid fluid;

    public RemoveFluidContainerFunction(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length < 1) {
            throw new TweakerExecuteException("removeContainer requires one argument");
        }
        TweakerItem container = RemoveFluidContainerFunction.notNull(arguments[0], "removeContainer container argument cannot be null").toItem("removeContainer container argument must be an item");
        FluidStack registered = FluidContainerRegistry.getFluidForFilledItem((ye)container.make(1));
        if (registered == null) {
            throw new TweakerExecuteException(container.getDisplayName() + " is not registered as fluid container");
        }
        if (registered.fluidID != this.fluid.getID()) {
            throw new TweakerExecuteException(container.getDisplayName() + " does not contain " + this.fluid.getLocalizedName());
        }
        if (!MineTweakerUtil.canRemoveContainer()) {
            Tweaker.log(Level.WARNING, "Container removal is unavailable. Action skipped.");
        } else {
            Tweaker.apply(new RemoveLiquidContainerAction(container));
        }
        return null;
    }

    @Override
    public String toString() {
        return "fluid.removeContainer";
    }
}

