/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.core.StackWrapper;
import buildcraft.api.fuels.IronEngineCoolant;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;

public class RemoveSolidCoolantAction
implements IUndoableAction {
    private final StackWrapper stack;
    private final FluidStack fluid;

    public RemoveSolidCoolantAction(StackWrapper stack) {
        this.stack = stack;
        this.fluid = (FluidStack)IronEngineCoolant.solidCoolants.get(stack);
    }

    @Override
    public void apply() {
        IronEngineCoolant.solidCoolants.remove(this.stack);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        IronEngineCoolant.solidCoolants.put(this.stack, this.fluid);
    }

    @Override
    public String describe() {
        return "Removing coolant item " + this.stack.stack.s();
    }

    @Override
    public String describeUndo() {
        return "Restoring coolant item " + this.stack.stack.s();
    }
}

