/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerLiquid;

public class BronzeEngineAddFuelAction
implements IUndoableAction {
    private final TweakerLiquid fluid;
    private final int powerPerCycle;
    private final int burnDuration;
    private final int dissipationMultiplier;

    public BronzeEngineAddFuelAction(TweakerLiquid fluid, int powerPerCycle, int burnDuration, int dissipationMultiplier) {
        this.fluid = fluid;
        this.powerPerCycle = powerPerCycle;
        this.burnDuration = burnDuration;
        this.dissipationMultiplier = dissipationMultiplier;
    }

    @Override
    public void apply() {
        FuelManager.bronzeEngineFuel.put(this.fluid.get(), new EngineBronzeFuel(this.fluid.get(), this.powerPerCycle, this.burnDuration, this.dissipationMultiplier));
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        FuelManager.bronzeEngineFuel.remove(this.fluid.get());
    }

    @Override
    public String describe() {
        return "Adding biogas engine fuel " + this.fluid.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Removing biogas engine fuel " + this.fluid.getDisplayName();
    }
}

