/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;

public class FermenterAddFuelAction
implements IUndoableAction {
    private final TweakerItem fuel;
    private final int fermentPerCycle;
    private final int cycles;
    private ye fuelItemStack;

    public FermenterAddFuelAction(TweakerItem fuel, int fermentPerCycle, int cycles) {
        this.fuel = fuel;
        this.fermentPerCycle = fermentPerCycle;
        this.cycles = cycles;
    }

    @Override
    public void apply() {
        this.fuelItemStack = this.fuel.make(1);
        FuelManager.fermenterFuel.put(this.fuelItemStack, new FermenterFuel(this.fuelItemStack, this.fermentPerCycle, this.cycles));
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        FuelManager.fermenterFuel.remove(this.fuelItemStack);
    }

    @Override
    public String describe() {
        return "Adding " + this.fuel.getDisplayName() + " as fermenter fuel";
    }

    @Override
    public String describeUndo() {
        return "Removing fermenter fuel " + this.fuel.getDisplayName();
    }
}

