/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.GeneratorFuel;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;

public class GeneratorAddFuelAction
implements IUndoableAction {
    private final TweakerLiquidStack fluid;
    private final GeneratorFuel fuel;

    public GeneratorAddFuelAction(TweakerLiquidStack fluidPerCycle, int euPerTick, int numTicks) {
        this.fluid = fluidPerCycle;
        this.fuel = new GeneratorFuel(fluidPerCycle.get(), euPerTick, numTicks);
    }

    @Override
    public void apply() {
        GeneratorFuel.fuels.put(this.fuel.fuelConsumed.fluidID, this.fuel);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        GeneratorFuel.fuels.remove(this.fuel.fuelConsumed.fluidID);
    }

    @Override
    public String describe() {
        return "Adding bio generator fuel " + this.fluid.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Removing bio generator fuel " + this.fluid.getDisplayName();
    }
}

