/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.GeneratorFuel;
import java.util.logging.Level;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerLiquid;

public class GeneratorRemoveFuelAction
implements IUndoableAction {
    private final TweakerLiquid fluid;
    private GeneratorFuel fuel;

    public GeneratorRemoveFuelAction(TweakerLiquid fluid) {
        this.fluid = fluid;
    }

    @Override
    public void apply() {
        this.fuel = (GeneratorFuel)GeneratorFuel.fuels.remove(this.fluid.get().getID());
        if (this.fuel == null) {
            Tweaker.log(Level.WARNING, "Could not find biogenetator fuel " + this.fluid.getDisplayName());
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.fuel != null) {
            GeneratorFuel.fuels.put(this.fluid.get().getID(), this.fuel);
        }
    }

    @Override
    public String describe() {
        return "Removing bio generator fuel " + this.fluid.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Restoring bio generator fuel " + this.fluid.getDisplayName();
    }
}

