/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import java.util.logging.Level;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;

public class RainmakerRemoveItemAction
implements IUndoableAction {
    private final ye item;
    private boolean asItem;
    private RainSubstrate substrate;

    public RainmakerRemoveItemAction(ye item) {
        this.item = item;
    }

    @Override
    public void apply() {
        if (FuelManager.rainSubstrate.containsKey(this.item)) {
            this.asItem = false;
            this.substrate = (RainSubstrate)FuelManager.rainSubstrate.remove(this.item);
        } else if (FuelManager.rainSubstrate.containsKey(this.item.b())) {
            this.asItem = true;
            this.substrate = (RainSubstrate)FuelManager.rainSubstrate.remove(this.item.b());
        } else {
            Tweaker.log(Level.WARNING, "Rainmaker item " + this.item.s() + " not found");
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.substrate != null) {
            if (this.asItem) {
                FuelManager.rainSubstrate.put(this.item.b(), this.substrate);
            } else {
                FuelManager.rainSubstrate.put(this.item, this.substrate);
            }
        }
    }

    @Override
    public String describe() {
        return "Removing rainmaker item " + this.item.s();
    }

    @Override
    public String describeUndo() {
        return "Restoring rainmaker item " + this.item.s();
    }
}

