/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.recipes.RecipeManagers;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;

public class SqueezerAddRecipeAction
implements IUndoableAction {
    private final TweakerLiquidStack output;
    private final TweakerItemStack[] input;
    private final int time;
    private final TweakerItem remnant;
    private final int remnantChance;

    public SqueezerAddRecipeAction(TweakerLiquidStack output, TweakerItemStack[] input, int time, TweakerItem remnant, int remnantChance) {
        this.output = output;
        this.input = input;
        this.time = time;
        this.remnant = remnant;
        this.remnantChance = remnantChance;
    }

    @Override
    public void apply() {
        ye[] inputs = new ye[this.input.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = this.input[i].get();
        }
        if (this.remnant == null) {
            RecipeManagers.squeezerManager.addRecipe(this.time, inputs, this.output.get());
        } else {
            RecipeManagers.squeezerManager.addRecipe(this.time, inputs, this.output.get(), this.remnant.make(1), this.remnantChance);
        }
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String describe() {
        return "Adding a squeezer recipe for " + this.output.getDisplayName();
    }

    @Override
    public String describeUndo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

