/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class GrinderAddBlacklistAction
implements IUndoableAction {
    private final Class<?> entityClass;
    private final boolean alreadyBlacklisted;

    public GrinderAddBlacklistAction(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.alreadyBlacklisted = MFRHacks.grindableBlacklist == null ? false : MFRHacks.grindableBlacklist.contains(entityClass);
    }

    @Override
    public void apply() {
        if (!this.alreadyBlacklisted) {
            FactoryRegistry.registerGrinderBlacklist((Class[])new Class[]{this.entityClass});
        }
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.grindableBlacklist != null;
    }

    @Override
    public void undo() {
        if (!this.alreadyBlacklisted) {
            MFRHacks.grindableBlacklist.remove(this.entityClass);
        }
    }

    @Override
    public String describe() {
        return "Blacklisting grindable " + this.entityClass.getCanonicalName();
    }

    @Override
    public String describeUndo() {
        return "Un-blacklisting grindable " + this.entityClass.getCanonicalName();
    }
}

