/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class GrinderRemoveBlacklistAction
implements IUndoableAction {
    private final Class<?> entityClass;
    private final boolean existed;

    public GrinderRemoveBlacklistAction(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.existed = MFRHacks.grindableBlacklist.contains(entityClass);
    }

    @Override
    public void apply() {
        if (this.existed) {
            MFRHacks.grindableBlacklist.remove(this.entityClass);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.existed) {
            MFRHacks.grindableBlacklist.add(this.entityClass);
        }
    }

    @Override
    public String describe() {
        return "Removing grindable blacklist entity " + this.entityClass.getCanonicalName();
    }

    @Override
    public String describeUndo() {
        return "Restoring grindable blacklist entity " + this.entityClass.getCanonicalName();
    }
}

