/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.mods.mfr.MFRHacks;
import stanhebben.minetweaker.mods.mfr.PrePlantAction;

public class PlanterAddPlantableAction
implements IUndoableAction {
    private final TweakerItem seed;
    private final TweakerItem plant;
    private final PrePlantAction preAction;
    private final IFactoryPlantable old;

    public PlanterAddPlantableAction(TweakerItem seed, TweakerItem plant, PrePlantAction preAction) {
        this.seed = seed;
        this.plant = plant;
        this.preAction = preAction;
        this.old = MFRHacks.plantables == null ? null : MFRHacks.plantables.get(seed.getItemId());
    }

    @Override
    public void apply() {
        FactoryRegistry.registerPlantable((IFactoryPlantable)new SimpleFactoryPlantable(this.seed.getItemId(), this.seed.getItemSubId(), this.plant.getItemId(), this.plant.getItemSubId(), this.preAction));
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.plantables != null;
    }

    @Override
    public void undo() {
        if (this.old == null) {
            MFRHacks.plantables.remove(this.seed.getItemId());
        } else {
            FactoryRegistry.registerPlantable((IFactoryPlantable)this.old);
        }
    }

    @Override
    public String describe() {
        return "Adding plantable " + this.seed.getDisplayName();
    }

    @Override
    public String describeUndo() {
        if (this.old == null) {
            return "Removing plantable " + this.seed.getDisplayName();
        }
        return "Restoring plantable " + this.seed.getDisplayName();
    }

    private static class SimpleFactoryPlantable
    implements IFactoryPlantable {
        private final int seedId;
        private final int seedMeta;
        private final int plantId;
        private final int plantMeta;
        private final PrePlantAction preAction;

        public SimpleFactoryPlantable(int seedId, int seedMeta, int plantId, int plantMeta, PrePlantAction preAction) {
            this.seedId = seedId;
            this.seedMeta = seedMeta;
            this.plantId = plantId;
            this.plantMeta = plantMeta;
            this.preAction = preAction;
        }

        public int getSeedId() {
            return this.seedId;
        }

        public int getPlantedBlockId(abw world, int x, int y, int z, ye stack) {
            return this.plantId;
        }

        public int getPlantedBlockMetadata(abw world, int x, int y, int z, ye stack) {
            return this.plantMeta;
        }

        public boolean canBePlantedHere(abw world, int x, int y, int z, ye stack) {
            if (this.preAction == PrePlantAction.TILL && world.a(x, y, z) != aqz.A.cF && world.a(x, y, z) != aqz.z.cF) {
                return false;
            }
            return stack.d == this.seedId && (this.seedMeta == Short.MAX_VALUE || this.seedMeta == stack.k()) && aqz.s[world.a(x, y, z)].isAirBlock(world, x, y, z);
        }

        public void prePlant(abw world, int x, int y, int z, ye stack) {
            if (this.preAction == PrePlantAction.TILL) {
                world.c(x, y, z, aqz.aF.cF);
            }
        }

        public void postPlant(abw world, int x, int y, int z, ye stack) {
        }
    }
}

