/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.script.parser;

public class CharStream {
    private char[] data;
    private int index;

    public CharStream(String data) {
        this.data = data.toCharArray();
        this.index = 0;
    }

    public boolean peek(char ch2) {
        if (this.index == this.data.length) {
            return false;
        }
        return this.data[this.index] == ch2;
    }

    public boolean optional(char ch2) {
        if (this.index == this.data.length) {
            return false;
        }
        if (this.data[this.index] == ch2) {
            ++this.index;
            return true;
        }
        return false;
    }

    public char optional(char from, char to) {
        if (this.index == this.data.length) {
            return '\u0000';
        }
        if (this.data[this.index] >= from && this.data[this.index] <= to) {
            return this.data[this.index++];
        }
        return '\u0000';
    }

    public void required(char ch2) {
        if (this.data[this.index] != ch2) {
            throw new IllegalArgumentException("Unexpected character: " + this.data[this.index]);
        }
        ++this.index;
    }

    public char required(char from, char to) {
        if (this.data[this.index] < from || this.data[this.index] > to) {
            throw new IllegalArgumentException("Unexpected character: " + this.data[this.index]);
        }
        return this.data[this.index++];
    }

    public char next() {
        return this.data[this.index++];
    }

    public boolean hasMore() {
        return this.index < this.data.length;
    }
}

