/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.util;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class DataArrayOutputStream {
    private byte[] data = new byte[16];
    private int length;

    public void write(byte[] value) {
        while (this.length + value.length > this.data.length) {
            this.expand();
        }
        for (byte b : value) {
            this.data[this.length++] = b;
        }
    }

    public void writeByte(int value) {
        if (this.length + 1 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = (byte)value;
    }

    public void writeShort(int value) {
        if (this.length + 2 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = (byte)(value >> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeInt(int value) {
        if (this.length + 4 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = (byte)(value >> 24);
        this.data[this.length++] = (byte)(value >> 16);
        this.data[this.length++] = (byte)(value >> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeLong(long value) {
        if (this.length + 8 > this.data.length) {
            this.expand();
        }
        this.data[this.length++] = (byte)(value >> 56);
        this.data[this.length++] = (byte)(value >> 48);
        this.data[this.length++] = (byte)(value >> 40);
        this.data[this.length++] = (byte)(value >> 32);
        this.data[this.length++] = (byte)(value >> 24);
        this.data[this.length++] = (byte)(value >> 16);
        this.data[this.length++] = (byte)(value >> 8);
        this.data[this.length++] = (byte)value;
    }

    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeByteArray(byte[] data) {
        this.writeInt(data.length);
        this.write(data);
    }

    public void writeUTF(String str) {
        try {
            byte[] value = str.getBytes("UTF-8");
            this.writeByteArray(value);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.length);
    }

    private void expand() {
        this.data = Arrays.copyOf(this.data, this.data.length * 2);
    }
}

