/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.modifiers;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMod;

public class IguanaModAttack
extends ToolMod {
    String tooltipName = "\u00a7fSharpness";
    int increase;
    int max = 120;
    int amount = Math.round((float)this.max / 3.0f);
    String guiType;

    public IguanaModAttack(String type, ItemStack[] items, int effect, int inc) {
        super(items, effect, "ModAttack");
        this.guiType = type;
        this.increase = inc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canModify(ItemStack tool, ItemStack[] input, boolean automated) {
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (!this.validType(toolItem)) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (automated) {
            if (!tags.func_74764_b(this.key)) return true;
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] + this.increase <= this.max) {
                return true;
            }
            if (this.max - keyPair[0] <= 0) return false;
            this.increase = this.max - keyPair[0];
            return true;
        }
        if (!tags.func_74764_b(this.key)) {
            if (tags.func_74762_e("Modifiers") <= 0) return false;
            return true;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] % this.amount == 0) {
            if (tags.func_74762_e("Modifiers") <= 0) return false;
            return true;
        }
        if (keyPair[0] + this.increase > keyPair[1]) return false;
        return true;
    }

    @Override
    public boolean canModify(ItemStack tool, ItemStack[] input) {
        return this.canModify(tool, input, false);
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b(this.key)) {
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.amount == 0) {
                int modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            }
            if (keyPair[0] + this.increase >= keyPair[1]) {
                int attack = tags.func_74762_e("Attack");
                tags.func_74768_a("Attack", ++attack);
                keyPair[1] = keyPair[1] + this.amount;
            }
            keyPair[0] = keyPair[0] + this.increase;
            tags.func_74783_a(this.key, keyPair);
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a7f" + this.guiType + " (" + this.increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{this.increase, this.amount, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a7f" + this.guiType + " (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(ToolCore tool) {
        return true;
    }

    public boolean nerfType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("throwing") || list.contains("ammo");
    }
}

