/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.modifiers;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMod;

public class IguanaModBlaze
extends ToolMod {
    String tooltipName = "\u00a76Fiery";
    int increase;
    int max;

    public IguanaModBlaze(ItemStack[] items, int effect, int inc) {
        super(items, effect, "Blaze");
        this.increase = inc;
        this.max = 25;
    }

    public boolean canModify(ItemStack tool, ItemStack[] input, boolean auto) {
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (!this.validType(toolItem)) {
            return false;
        }
        if (auto) {
            return true;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            return tags.func_74762_e("Modifiers") > 0 && this.increase <= this.max;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] + this.increase <= keyPair[1]) {
            return true;
        }
        if (keyPair[0] == keyPair[1]) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        return false;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        return this.canModify(tool, input, false);
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74764_b(this.key)) {
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] == this.max) {
                keyPair[0] = keyPair[0] + this.increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                int modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + this.increase;
                tags.func_74783_a(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a76Blaze (" + this.increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{this.increase, this.max, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
        }
        int fiery = tags.func_74762_e("Fiery");
        tags.func_74768_a("Fiery", fiery += this.increase);
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a76Blaze (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("melee") || list.contains("ammo");
    }
}

