/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct.modifiers;

import iguanaman.iguanatweakstconstruct.configs.IguanaConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMod;

public class IguanaModRepair
extends ToolMod {
    public IguanaModRepair() {
        super(new ItemStack[0], 0, "");
    }

    @Override
    public boolean matches(ItemStack[] input, ItemStack tool) {
        return this.canModify(tool, input);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        if (input[0] == null && input[1] == null || input[0] != null && input[1] != null) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74762_e("Damage") > 0) {
            int headID = tags.func_74762_e("Head");
            int matID = -1;
            matID = input[0] != null ? PatternBuilder.instance.getPartID(input[0]) : PatternBuilder.instance.getPartID(input[1]);
            if (matID == headID && this.amountToRepair(input, tool) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int damage;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_74757_a("Broken", false);
        int increase = this.amountToRepair(input, tool);
        int olddamage = damage = tags.func_74762_e("Damage");
        int repair = tags.func_74762_e("RepairCount");
        if ((damage -= increase) < 0) {
            damage = 0;
        }
        tags.func_74768_a("Damage", damage);
        tags.func_74768_a("RepairCount", repair += olddamage - damage);
        AbilityHelper.damageTool(tool, 0, null, true);
    }

    @Override
    public void addMatchingEffect(ItemStack tool) {
    }

    public int amountToRepair(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int dur = tags.func_74762_e("BaseDurability");
        int materialValue = 0;
        materialValue = input[0] != null ? PatternBuilder.instance.getPartValue(input[0]) : PatternBuilder.instance.getPartValue(input[1]);
        int increase = (int)(50.0f + (float)dur * 0.4f * (float)materialValue);
        int modifiers = tags.func_74762_e("Modifiers");
        float mods = 1.0f;
        if (modifiers == 2) {
            mods = 0.8f;
        } else if (modifiers == 1) {
            mods = 0.6f;
        } else if (modifiers == 0) {
            mods = 0.4f;
        }
        increase = (int)((float)increase * mods);
        increase = (int)((float)increase / ((ToolCore)tool.func_77973_b()).getRepairCost());
        int durtotal = tags.func_74762_e("TotalDurability");
        int repair = tags.func_74762_e("RepairCount");
        float repairCount = (float)repair / (float)durtotal;
        if (IguanaConfig.repairLimitActive && repairCount >= (float)IguanaConfig.repairLimit) {
            return 0;
        }
        increase = Math.round((float)increase / ((float)IguanaConfig.repairCostPercentage / 100.0f));
        if (IguanaConfig.repairCostScaling) {
            repairCount /= (float)IguanaConfig.repairScalingModifier;
            increase = Math.round((float)increase / (repairCount += 1.0f));
        }
        return increase;
    }
}

