/*
 * Decompiled with CFR 0.152.
 */
package okushama.nek;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import okushama.nek.NotEnoughKeys;

public class KeybindTracker {
    public static HashMap<String, ArrayList<KeyBinding>> modKeybinds = new HashMap();
    public static HashMap<String, String> modIds = new HashMap();

    public static int getKeybindIndex(KeyBinding kb) {
        for (int i = 0; i < Minecraft.func_71410_x().field_71474_y.field_74324_K.length; ++i) {
            KeyBinding keb = Minecraft.func_71410_x().field_71474_y.field_74324_K[i];
            if (!keb.field_74515_c.equals(kb.field_74515_c)) continue;
            return i;
        }
        return -1;
    }

    public static String getHostCategory(KeyBinding kb) {
        for (String key : modKeybinds.keySet()) {
            ArrayList<KeyBinding> binds = modKeybinds.get(key);
            for (KeyBinding bind : binds) {
                if (!bind.equals(kb)) continue;
                return key;
            }
        }
        return "";
    }

    private static ArrayList<KeyBinding> getConflictingKeybinds() {
        ArrayList<KeyBinding> allTheBinds = new ArrayList<KeyBinding>();
        ArrayList<KeyBinding> allTheConflicts = new ArrayList<KeyBinding>();
        for (String key : modKeybinds.keySet()) {
            ArrayList<KeyBinding> binds = modKeybinds.get(key);
            for (KeyBinding bind : binds) {
                allTheBinds.add(bind);
            }
        }
        for (KeyBinding bind : allTheBinds) {
            for (KeyBinding obind : allTheBinds) {
                if (obind.field_74515_c.equals(bind.field_74515_c) || obind.field_74512_d != bind.field_74512_d) continue;
                allTheConflicts.add(bind);
                allTheConflicts.add(obind);
            }
        }
        HashSet<KeyBinding> hs = new HashSet<KeyBinding>();
        hs.addAll(allTheConflicts);
        allTheConflicts.clear();
        allTheConflicts.addAll(hs);
        return allTheConflicts;
    }

    public static void populate() {
        KeyBinding[] keyBinds = Minecraft.func_71410_x().field_71474_y.field_74324_K;
        Field keyHandlers_Field = KeybindTracker.getDeclaredField("cpw.mods.fml.client.registry.KeyBindingRegistry", "keyHandlers");
        HashMap<KeyBinding, String> tempKeys = new HashMap<KeyBinding, String>();
        try {
            Set keyHandlers = (Set)keyHandlers_Field.get(KeyBindingRegistry.instance());
            for (KeyBindingRegistry.KeyHandler keyhandler : keyHandlers) {
                for (int i = 0; i < keyhandler.getKeyBindings().length; ++i) {
                    tempKeys.put(keyhandler.getKeyBindings()[i], KeybindTracker.idFromObject(keyhandler));
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (KeyBinding kb : tempKeys.keySet()) {
            String s = (String)tempKeys.get(kb);
            if (!modKeybinds.containsKey(s)) {
                modKeybinds.put(s, new ArrayList());
            }
            modKeybinds.get(s).add(kb);
        }
        KeybindTracker.updateConflictCategory();
    }

    public static void updateConflictCategory() {
        if (KeybindTracker.getConflictingKeybinds().size() > 0) {
            modKeybinds.put("Conflicting", KeybindTracker.getConflictingKeybinds());
        } else if (modKeybinds.containsKey("Conflicting")) {
            modKeybinds.remove("Conflicting");
        }
    }

    public static Field getDeclaredField(String classname, String fieldname) {
        try {
            Class<?> class_ = Class.forName(classname);
            Field field_ = class_.getDeclaredField(fieldname);
            field_.setAccessible(true);
            return field_;
        }
        catch (NoSuchFieldException e) {
            NotEnoughKeys.log(String.format("== Field %s %s not found !\n", classname, fieldname));
            return null;
        }
        catch (SecurityException e) {
            NotEnoughKeys.log(String.format("== Field %s %s security exception !\n", classname, fieldname));
            return null;
        }
        catch (ClassNotFoundException e) {
            NotEnoughKeys.log(String.format("== Class %s not found !\n", classname));
            return null;
        }
    }

    public static String idFromObject(Object obj) {
        String objPath = obj.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        try {
            objPath = URLDecoder.decode(objPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String modName = "<Unknown>";
        for (String s : modIds.keySet()) {
            if (!objPath.contains(s) || s.contains("nek")) continue;
            modName = modIds.get(s);
            break;
        }
        if (modName.equals("Not Enough Keys")) {
            modName = "Unsorted";
        }
        if (modName.equals("Minecraft Coder Pack")) {
            modName = "Minecraft";
        }
        return modName;
    }
}

