/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import net.minecraft.launchwrapper.IClassTransformer;
import openmods.Log;
import openmods.asm.VisitorHelper;
import openmods.include.IncludingClassVisitor;
import openmods.movement.MovementPatcher;
import openmods.world.MapGenStructureVisitor;
import org.objectweb.asm.ClassVisitor;

public class OpenModsClassTransformer
implements IClassTransformer {
    private static boolean applyMovementTransformer = System.getProperty("openmods.legacy_movement") == null;
    private static boolean applyMapgenFix = System.getProperty("openmods.no_mapgen_fix") == null;
    private static final VisitorHelper.TransformProvider INCLUDING_CV = new VisitorHelper.TransformProvider(){

        @Override
        public ClassVisitor createVisitor(ClassVisitor cv) {
            return new IncludingClassVisitor(cv);
        }
    };

    public byte[] transform(final String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        if (applyMovementTransformer && transformedName.equals("net.minecraft.client.entity.EntityPlayerSP")) {
            return VisitorHelper.apply(bytes, 2, new VisitorHelper.TransformProvider(){

                @Override
                public ClassVisitor createVisitor(ClassVisitor cv) {
                    Log.info("Trying to apply movement callback (class: %s)", name);
                    return new MovementPatcher(name, cv);
                }
            });
        }
        if (applyMapgenFix && transformedName.equals("net.minecraft.world.gen.structure.MapGenStructure")) {
            return VisitorHelper.apply(bytes, 2, new VisitorHelper.TransformProvider(){

                @Override
                public ClassVisitor createVisitor(ClassVisitor cv) {
                    Log.info("Trying to patch MapGenStructure (class: %s)", name);
                    return new MapGenStructureVisitor(name, cv);
                }
            });
        }
        if (name.startsWith("net.minecraft.")) {
            return bytes;
        }
        return VisitorHelper.apply(bytes, 0, INCLUDING_CV);
    }
}

