/*
 * Decompiled with CFR 0.152.
 */
package openmods.block;

import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.block.OpenBlock;

public class RotationHelper {
    public static boolean rotateBlock(OpenBlock block, World world, int x, int y, int z, ForgeDirection axis) {
        switch (block.getRotationMode()) {
            case FOUR_DIRECTIONS: {
                return RotationHelper.rotateFourDirections(world, x, y, z, axis);
            }
            case SIX_DIRECTIONS: {
                return RotationHelper.rotateSixDirection(world, x, y, z, axis);
            }
            case TWENTYFOUR_DIRECTIONS: {
                return RotationHelper.rotateTwentyFourDirections(world, x, y, z, axis);
            }
        }
        return false;
    }

    private static void rotate(World world, int x, int y, int z, ForgeDirection axis) {
        ForgeDirection dir = RotationHelper.getBlockRotation(world, x, y, z);
        ForgeDirection rotatedDir = dir.getRotation(axis);
        world.func_72921_c(x, y, z, rotatedDir.ordinal(), 3);
    }

    protected static ForgeDirection getBlockRotation(World world, int x, int y, int z) {
        int currentMeta = world.func_72805_g(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)currentMeta);
        return dir;
    }

    private static boolean rotateFourDirections(World world, int x, int y, int z, ForgeDirection axis) {
        switch (axis) {
            case UP: 
            case DOWN: {
                RotationHelper.rotate(world, x, y, z, axis);
                return true;
            }
        }
        return false;
    }

    private static boolean rotateSixDirection(World world, int x, int y, int z, ForgeDirection axis) {
        RotationHelper.rotate(world, x, y, z, axis);
        return true;
    }

    private static boolean rotateTwentyFourDirections(World world, int x, int y, int z, ForgeDirection axis) {
        return false;
    }
}

