/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import openmods.gui.component.BaseComponent;
import org.lwjgl.opengl.GL11;

public class GuiComponentBox
extends BaseComponent {
    protected int width;
    protected int height;
    protected int u;
    protected int v;
    protected int color;
    private boolean overlay_mode;

    public boolean isOverlay() {
        return this.overlay_mode;
    }

    public BaseComponent setOverlayMode(boolean isOverlay) {
        this.overlay_mode = isOverlay;
        return this;
    }

    public GuiComponentBox(int x, int y, int width, int height, int u, int v, int color) {
        super(x, y);
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.color = color;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getColor() {
        return this.color;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void renderTopLeftCorner(int offsetX, int offsetY) {
        this.func_73729_b(offsetX + this.x, offsetY + this.y, this.u, this.v, 4, 4);
    }

    public void renderTopRightCorner(int offsetX, int offsetY) {
        this.func_73729_b(offsetX + this.x + this.getWidth() - 3, offsetY + this.y, this.u + 5, this.v, 3, 3);
    }

    public void renderBottomLeftCorner(int offsetX, int offsetY) {
        this.func_73729_b(offsetX + this.x, offsetY + this.y + this.getHeight() - 3, this.u + 11, this.v, 3, 3);
    }

    public void renderBottomRightCorner(int offsetX, int offsetY) {
        this.func_73729_b(offsetX + this.x + this.getWidth() - 4, offsetY + this.y + this.getHeight() - 4, this.u + 15, this.v, 4, 4);
    }

    public void renderBottomEdge(int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + this.x + 3), (double)(offsetY + this.y + this.getHeight() - 3), (double)0.0);
        GL11.glScaled((double)(this.getWidth() - 6), (double)1.0, (double)0.0);
        this.func_73729_b(0, 0, this.u + 14, this.v, 1, 3);
        GL11.glPopMatrix();
    }

    public void renderTopEdge(int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + this.x + 3), (double)(offsetY + this.y), (double)0.0);
        GL11.glScaled((double)(this.getWidth() - 6), (double)1.0, (double)0.0);
        this.func_73729_b(0, 0, this.u + 4, this.v, 1, 3);
        GL11.glPopMatrix();
    }

    public void renderLeftEdge(int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + this.x), (double)(offsetY + this.y + 3), (double)0.0);
        GL11.glScaled((double)1.0, (double)(this.getHeight() - 6), (double)0.0);
        this.func_73729_b(0, 0, this.u, this.v + 4, 3, 1);
        GL11.glPopMatrix();
    }

    public void renderRightEdge(int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + this.x + this.getWidth() - 3), (double)(offsetY + this.y + 3), (double)0.0);
        GL11.glScaled((double)1.0, (double)(this.getHeight() - 6), (double)0.0);
        this.func_73729_b(0, 0, this.u + 8, this.v, 3, 1);
        GL11.glPopMatrix();
    }

    public void renderBackground(int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + this.x + 2), (double)(offsetY + this.y + 2), (double)0.0);
        GL11.glScaled((double)(this.getWidth() - 4), (double)(this.getHeight() - 4), (double)0.0);
        this.func_73729_b(0, 0, this.u + 19, this.v, 1, 1);
        GL11.glPopMatrix();
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (!this.overlay_mode) {
            this.doRender(minecraft, offsetX, offsetY, mouseX, mouseY);
        }
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.overlay_mode) {
            this.doRender(minecraft, offsetX, offsetY, mouseX, mouseY);
        }
        super.renderOverlay(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    protected void doRender(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        RenderHelper.func_74518_a();
        this.bindComponentsSheet();
        int c = this.getColor();
        float r = (float)(c >> 16 & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.renderBackground(offsetX, offsetY);
        this.renderTopEdge(offsetX, offsetY);
        this.renderBottomEdge(offsetX, offsetY);
        this.renderLeftEdge(offsetX, offsetY);
        this.renderRightEdge(offsetX, offsetY);
        this.renderTopLeftCorner(offsetX, offsetY);
        this.renderTopRightCorner(offsetX, offsetY);
        this.renderBottomLeftCorner(offsetX, offsetY);
        this.renderBottomRightCorner(offsetX, offsetY);
    }
}

