/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import openmods.gui.component.GuiComponentSprite;
import org.lwjgl.opengl.GL11;

public class GuiComponentCraftingGrid
extends GuiComponentSprite {
    private static final int CRAZY_1 = 0x505000FF;
    private static final int CRAZY_2 = 2621567;
    private static final int CRAZY_3 = -267386864;
    protected static RenderItem itemRenderer = new RenderItem();
    private ItemStack[] items;

    public GuiComponentCraftingGrid(int x, int y, ItemStack[] items, Icon icon, ResourceLocation texture) {
        super(x, y, icon, texture);
        this.items = items;
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderOverlay(minecraft, offsetX, offsetY, mouseX, mouseY);
        int relativeMouseX = mouseX + offsetX - this.x;
        int relativeMouseY = mouseY + offsetY - this.y;
        int gridOffsetX = 1;
        int gridOffsetY = 1;
        int itemBoxSize = 19;
        ItemStack tooltip = null;
        int i = 0;
        for (ItemStack input : this.items) {
            if (input != null) {
                int row = i % 3;
                int column = i / 3;
                int itemX = offsetX + gridOffsetX + row * itemBoxSize;
                int itemY = offsetY + gridOffsetY + column * itemBoxSize;
                this.drawItemStack(input, this.x + itemX, this.y + itemY, "");
                if (relativeMouseX > itemX - 2 && relativeMouseX < itemX - 2 + itemBoxSize && relativeMouseY > itemY - 2 && relativeMouseY < itemY - 2 + itemBoxSize) {
                    tooltip = input;
                }
            }
            ++i;
        }
        if (tooltip != null) {
            this.drawItemStackTooltip(tooltip, relativeMouseX + 25, relativeMouseY + 30);
        }
    }

    protected void drawHoveringText(List<String> lines, int x, int y, FontRenderer font) {
        if (lines.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2929);
        int width = 0;
        for (String s : lines) {
            int l = font.func_78256_a(s);
            if (l <= width) continue;
            width = l;
        }
        int i1 = x + 12;
        int j1 = y - 12;
        int lineCount = lines.size();
        int height = 8;
        if (lineCount > 1) {
            height += 2 + (lineCount - 1) * 10;
        }
        this.field_73735_i = 350.0f;
        GuiComponentCraftingGrid.itemRenderer.field_77023_b = 350.0f;
        this.func_73733_a(i1 - 3, j1 - 4, i1 + width + 3, j1 - 3, -267386864, -267386864);
        this.func_73733_a(i1 - 3, j1 + height + 3, i1 + width + 3, j1 + height + 4, -267386864, -267386864);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + width + 3, j1 + height + 3, -267386864, -267386864);
        this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + height + 3, -267386864, -267386864);
        this.func_73733_a(i1 + width + 3, j1 - 3, i1 + width + 4, j1 + height + 3, -267386864, -267386864);
        this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + height + 3 - 1, 0x505000FF, 2621567);
        this.func_73733_a(i1 + width + 2, j1 - 3 + 1, i1 + width + 3, j1 + height + 3 - 1, 0x505000FF, 2621567);
        this.func_73733_a(i1 - 3, j1 - 3, i1 + width + 3, j1 - 3 + 1, 0x505000FF, 0x505000FF);
        this.func_73733_a(i1 - 3, j1 + height + 2, i1 + width + 3, j1 + height + 3, 2621567, 2621567);
        for (int i = 0; i < lineCount; ++i) {
            String s1 = lines.get(i);
            font.func_78261_a(s1, i1, j1, -1);
            if (i == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.field_73735_i = 0.0f;
        GuiComponentCraftingGrid.itemRenderer.field_77023_b = 0.0f;
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    protected void drawItemStackTooltip(ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = (FontRenderer)Objects.firstNonNull((Object)stack.func_77973_b().getFontRenderer(stack), (Object)mc.field_71466_p);
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        ArrayList colored = Lists.newArrayListWithCapacity((int)list.size());
        colored.add(this.getRarityColor(stack) + (String)list.get(0));
        for (String line : list) {
            colored.add(EnumChatFormatting.GRAY + line);
        }
        this.drawHoveringText(colored, x, y, font);
    }

    protected EnumChatFormatting getRarityColor(ItemStack stack) {
        return EnumChatFormatting.values()[stack.func_77953_t().field_77937_e];
    }

    private void drawItemStack(ItemStack par1ItemStack, int par2, int par3, String par4Str) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        GuiComponentCraftingGrid.itemRenderer.field_77023_b = 200.0f;
        RenderHelper.func_74520_c();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2977);
        FontRenderer font = null;
        if (par1ItemStack != null) {
            font = par1ItemStack.func_77973_b().getFontRenderer(par1ItemStack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        itemRenderer.func_82406_b(font, Minecraft.func_71410_x().func_110434_K(), par1ItemStack, par2, par3);
        itemRenderer.func_94148_a(font, Minecraft.func_71410_x().func_110434_K(), par1ItemStack, par2, par3, par4Str);
        this.field_73735_i = 0.0f;
        GuiComponentCraftingGrid.itemRenderer.field_77023_b = 0.0f;
    }
}

