/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import openmods.gui.component.BaseComponent;
import openmods.sync.SyncableString;
import org.lwjgl.opengl.GL11;

public class GuiComponentLabel
extends BaseComponent {
    private String text;
    private SyncableString textObj;
    private float scale = 1.0f;
    private String textDelta;
    private String[] formattedText;
    private int maxHeight;
    private int maxWidth;
    private float additionalScale = 1.0f;
    private int additionalLineHeight = 0;

    private static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public GuiComponentLabel(int x, int y, int width, int height, SyncableString txt) {
        this(x, y, width, height, txt.getValue());
        this.textObj = txt;
    }

    public GuiComponentLabel(int x, int y, String text) {
        this(x, y, GuiComponentLabel.getFontRenderer().func_78256_a(text), GuiComponentLabel.getFontRenderer().field_78288_b, text);
    }

    public GuiComponentLabel(int x, int y, SyncableString txt) {
        this(x, y, txt.getValue());
        this.textObj = txt;
    }

    public GuiComponentLabel(int x, int y, int width, int height, String text) {
        super(x, y);
        this.text = text;
        this.formattedText = new String[10];
        this.setMaxHeight(height);
        this.setMaxWidth(width);
    }

    private void compileFormattedText(FontRenderer fr) {
        this.textDelta = this.getText();
        if (this.textDelta == null) {
            return;
        }
        this.formattedText = fr.func_78271_c(this.textDelta, this.getMaxWidth()).toArray(this.formattedText);
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
        float f = this.additionalScale = sr.func_78325_e() % 2 == 1 && this.scale < 1.0f ? 0.667f : 1.0f;
        if (this.getMaxHeight() < minecraft.field_71466_p.field_78288_b) {
            return;
        }
        if (this.getMaxWidth() < minecraft.field_71466_p.func_78263_a('m')) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + this.x), (double)(offsetY + this.y), (double)1.0);
        GL11.glScalef((float)(this.scale * this.additionalScale), (float)(this.scale * this.additionalScale), (float)(this.scale * this.additionalScale));
        this.compileFormattedText(minecraft.field_71466_p);
        int offset = 0;
        int lineCount = 0;
        for (String s : this.formattedText) {
            if (s == null) break;
            minecraft.field_71466_p.func_78276_b(s, 0, offset, 0x404040);
            offset += this.getFontHeight();
            if (++lineCount >= this.getMaxLines()) break;
        }
        GL11.glPopMatrix();
    }

    private int calculateHeight() {
        FontRenderer fr = GuiComponentLabel.getFontRenderer();
        this.compileFormattedText(fr);
        int offset = 0;
        int lineCount = 0;
        for (String s : this.formattedText) {
            if (s == null) break;
            offset += this.getFontHeight();
            if (++lineCount >= this.getMaxLines()) break;
        }
        return offset;
    }

    private int calculateWidth() {
        FontRenderer fr = GuiComponentLabel.getFontRenderer();
        this.compileFormattedText(fr);
        float maxWidth = 0.0f;
        for (String s : this.formattedText) {
            if (s == null) break;
            float width = fr.func_78256_a(s);
            if (!(width > maxWidth)) continue;
            maxWidth = width;
        }
        return (int)maxWidth;
    }

    public GuiComponentLabel setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public float getScale() {
        return this.scale;
    }

    public GuiComponentLabel setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public void setAdditionalLineHeight(int lh) {
        this.additionalLineHeight = lh;
    }

    public int getFontHeight() {
        return GuiComponentLabel.getFontRenderer().field_78288_b + this.additionalLineHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public GuiComponentLabel setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public int getMaxLines() {
        return (int)Math.floor((float)this.getMaxHeight() / (this.scale / this.additionalScale) / (float)this.getFontHeight());
    }

    public int getMaxWidth() {
        return (int)((float)this.maxWidth / this.additionalScale);
    }

    @Override
    public int getHeight() {
        return (int)((double)Math.min(this.getMaxHeight(), this.calculateHeight()) + 0.5);
    }

    @Override
    public int getWidth() {
        return (int)((double)Math.min(this.getMaxWidth(), this.calculateWidth()) + 0.5);
    }

    public String getText() {
        String pre = this.textObj != null ? this.textObj.getValue() : this.text;
        return pre == null ? "" : pre;
    }
}

