/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import openmods.gui.component.BaseComponent;
import openmods.sync.SyncableFloat;

public class GuiComponentLevel
extends BaseComponent {
    private int width;
    private int height;
    private int fColor;
    private int bColor;
    private float value;
    private float min;
    private float max;
    private SyncableFloat valueObj = null;

    public GuiComponentLevel(int x, int y, int width, int height, int levelColor, int backgroundColor, float min, float max, float value) {
        super(x, y);
        this.width = width;
        this.height = height;
        this.fColor = levelColor;
        this.bColor = backgroundColor;
        this.min = min;
        this.max = max;
        this.value = value;
    }

    public GuiComponentLevel(int x, int y, int width, int height, int levelColor, int backgroundColor, float min, float max, SyncableFloat value) {
        super(x, y);
        this.width = width;
        this.height = height;
        this.fColor = levelColor;
        this.bColor = backgroundColor;
        this.min = min;
        this.max = max;
        this.value = value.getValue();
        this.valueObj = value;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setValue(float v) {
        this.value = v;
    }

    public float getValue() {
        if (this.valueObj != null) {
            return this.valueObj.getValue();
        }
        return this.value;
    }

    private float getFillHeight() {
        float value = this.getValue();
        if (value > this.max) {
            value = this.max;
        }
        if (value < this.min) {
            value = this.min;
        }
        float percent = value / this.max;
        return percent * (float)this.getHeight();
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        int oX = this.x + offsetX;
        int oY = this.y + offsetY;
        GuiComponentLevel.func_73734_a((int)oX, (int)oY, (int)(oX + this.width), (int)(oY + this.height), (int)this.bColor);
        GuiComponentLevel.func_73734_a((int)oX, (int)(oY + (this.height - (int)this.getFillHeight())), (int)(oX + this.width), (int)(oY + this.height), (int)this.fColor);
    }
}

