/*
 * Decompiled with CFR 0.152.
 */
package openmods.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import openmods.item.IMetaItem;

public abstract class ItemGeneric
extends Item {
    protected Map<Integer, IMetaItem> metaitems = Maps.newHashMap();

    public ItemGeneric(int id) {
        super(id);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void registerItem(int id, IMetaItem item) {
        IMetaItem prev = this.metaitems.put(id, item);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Config error: replacing meta item %s with %s", (Object[])new Object[]{prev, item});
    }

    public void initRecipes() {
        for (IMetaItem item : this.metaitems.values()) {
            item.addRecipe();
        }
    }

    public void func_94581_a(IconRegister register) {
        for (IMetaItem item : this.metaitems.values()) {
            item.registerIcons(register);
        }
    }

    public Icon func_77617_a(int i) {
        IMetaItem meta = this.getMeta(i);
        if (meta != null) {
            return meta.getIcon();
        }
        return null;
    }

    public String func_77667_c(ItemStack stack) {
        IMetaItem meta = this.getMeta(stack.func_77960_j());
        if (meta != null) {
            return "item." + meta.getUnlocalizedName(stack);
        }
        return "";
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        IMetaItem meta = this.getMeta(itemStack.func_77960_j());
        if (meta != null) {
            return meta.onItemUse(itemStack, player, world, x, y, z, side, par8, par9, par10);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        IMetaItem meta = this.getMeta(itemStack.func_77960_j());
        if (meta != null) {
            return meta.onItemRightClick(itemStack, player, world);
        }
        return itemStack;
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase player) {
        IMetaItem meta = this.getMeta(itemStack.func_77960_j());
        if (meta != null) {
            return meta.hitEntity(itemStack, target, player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack itemStack, int pass) {
        IMetaItem meta = this.getMeta(itemStack.func_77960_j());
        return meta != null ? meta.hasEffect(pass) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs tab, List subItems) {
        for (Map.Entry<Integer, IMetaItem> entry : this.metaitems.entrySet()) {
            entry.getValue().addToCreativeList(id, entry.getKey(), subItems);
        }
    }

    public IMetaItem getMeta(int id) {
        return this.metaitems.get(id);
    }

    public IMetaItem getMeta(ItemStack itemStack) {
        return this.getMeta(itemStack.func_77960_j());
    }

    public ItemStack newItemStack(int id) {
        return this.newItemStack(id, 1);
    }

    public ItemStack newItemStack(int id, int number) {
        return new ItemStack((Item)this, number, id);
    }

    public ItemStack newItemStack(IMetaItem meta, int size) {
        for (Map.Entry<Integer, IMetaItem> o : this.metaitems.entrySet()) {
            if (!o.getValue().equals(meta)) continue;
            return this.newItemStack(o.getKey(), size);
        }
        return null;
    }
}

