/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import openmods.Log;
import openmods.OpenMods;
import openmods.integration.modules.BuildCraftPipes;
import openmods.sync.SyncableFlags;
import openmods.utils.BlockUtils;
import openmods.utils.Coord;

public class GenericTank
extends FluidTank {
    private List<ForgeDirection> surroundingTanks = Lists.newArrayList();
    private long lastUpdate = 0L;
    private final IFluidFilter filter;
    private static final IFluidFilter NO_RESTRICTIONS = new IFluidFilter(){

        @Override
        public boolean canAcceptFluid(FluidStack stack) {
            return true;
        }
    };

    private static IFluidFilter filter(final FluidStack ... acceptableFluids) {
        if (acceptableFluids.length == 0) {
            return NO_RESTRICTIONS;
        }
        return new IFluidFilter(){

            @Override
            public boolean canAcceptFluid(FluidStack stack) {
                for (FluidStack acceptableFluid : acceptableFluids) {
                    if (!acceptableFluid.isFluidEqual(stack)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public GenericTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity);
        this.filter = GenericTank.filter(acceptableFluids);
    }

    private static boolean isNeighbourTank(World world, Coord coord, ForgeDirection dir) {
        TileEntity tile = BlockUtils.getTileInDirection(world, coord, dir);
        return tile instanceof IFluidHandler;
    }

    private static Set<ForgeDirection> getSurroundingTanks(World world, Coord coord, SyncableFlags sides) {
        EnumSet<ForgeDirection> result = EnumSet.noneOf(ForgeDirection.class);
        if (sides == null) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!GenericTank.isNeighbourTank(world, coord, dir)) continue;
                result.add(dir);
            }
        } else {
            for (Integer s : sides.getActiveSlots()) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)s);
                if (!GenericTank.isNeighbourTank(world, coord, dir)) continue;
                result.add(dir);
            }
        }
        return result;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.fluid == null || this.fluid.isFluidEqual(resource)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public int getSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || !this.filter.canAcceptFluid(resource)) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    private void periodicUpdateNeighbours(World world, Coord coord, SyncableFlags sides) {
        long currentTime = OpenMods.proxy.getTicks(world);
        if (currentTime - this.lastUpdate > 10L) {
            this.surroundingTanks = Lists.newArrayList(GenericTank.getSurroundingTanks(world, coord, sides));
            this.lastUpdate = currentTime;
        }
    }

    private static int tryFillNeighbour(FluidStack drainedFluid, ForgeDirection side, TileEntity otherTank) {
        FluidStack toFill = drainedFluid.copy();
        ForgeDirection fillSide = side.getOpposite();
        if (otherTank instanceof IFluidHandler) {
            return ((IFluidHandler)otherTank).fill(fillSide, toFill, true);
        }
        return BuildCraftPipes.access().tryAcceptIntoPipe(otherTank, toFill, fillSide);
    }

    public void distributeToSides(int maxAmount, TileEntity currentTile) {
        this.distributeToSides(maxAmount, currentTile);
    }

    public void distributeToSides(int amountPerTick, World world, Coord coord, SyncableFlags sides) {
        if (world == null) {
            return;
        }
        if (this.getFluidAmount() <= 0) {
            return;
        }
        this.periodicUpdateNeighbours(world, coord, sides);
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        FluidStack drainedFluid = this.drain(amountPerTick, false);
        if (drainedFluid != null && drainedFluid.amount > 0) {
            int distributed;
            int startingAmount = drainedFluid.amount;
            Collections.shuffle(this.surroundingTanks);
            for (ForgeDirection side : this.surroundingTanks) {
                if (drainedFluid.amount <= 0) break;
                TileEntity otherTank = BlockUtils.getTileInDirection(world, coord, side);
                if (otherTank == null) continue;
                drainedFluid.amount -= GenericTank.tryFillNeighbour(drainedFluid, side, otherTank);
            }
            if ((distributed = startingAmount - drainedFluid.amount) > 0) {
                this.drain(distributed, true);
            }
        }
    }

    public void fillFromSides(int maxAmount, World world, Coord coord) {
        this.fillFromSides(maxAmount, world, coord, null);
    }

    public void fillFromSides(int maxAmount, World world, Coord coord, SyncableFlags sides) {
        if (world == null) {
            return;
        }
        int toDrain = Math.min(maxAmount, this.getSpace());
        if (toDrain <= 0) {
            return;
        }
        this.periodicUpdateNeighbours(world, coord, sides);
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        Collections.shuffle(this.surroundingTanks);
        block0: for (ForgeDirection side : this.surroundingTanks) {
            if (toDrain <= 0) break;
            TileEntity otherTank = BlockUtils.getTileInDirection(world, coord, side);
            if (!(otherTank instanceof IFluidHandler)) continue;
            IFluidHandler handler = (IFluidHandler)otherTank;
            ForgeDirection drainSide = side.getOpposite();
            FluidTankInfo[] infos = handler.getTankInfo(drainSide);
            if (infos == null) {
                Log.fine("Tank %s @ (%d,%d,%d) returned null tank info. Nasty.", otherTank.getClass(), otherTank.field_70329_l, otherTank.field_70330_m, otherTank.field_70327_n);
                continue;
            }
            for (FluidTankInfo info : infos) {
                if (!this.filter.canAcceptFluid(info.fluid)) continue;
                FluidStack stack = info.fluid.copy();
                stack.amount = toDrain;
                FluidStack drained = handler.drain(drainSide, stack, true);
                if (drained != null) {
                    this.fill(drained, true);
                    toDrain -= drained.amount;
                }
                if (toDrain <= 0) break block0;
            }
        }
    }

    public static interface IFluidFilter {
        public boolean canAcceptFluid(FluidStack var1);
    }
}

