/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.primitives.SignedBytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableByte
extends SyncableObjectBase {
    private byte value;

    public SyncableByte(byte value) {
        this.value = value;
    }

    public SyncableByte() {
    }

    public void setValue(byte newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        this.value = stream.readByte();
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        stream.writeByte(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74774_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74771_c(name);
    }

    public void modify(int by) {
        this.setValue(SignedBytes.checkedCast((long)(this.value + by)));
    }
}

