/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import openmods.OpenMods;
import openmods.proxy.IOpenModsProxy;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;

public class SyncableFlags
extends SyncableObjectBase {
    private short value;
    private short previousValue;
    protected long[] timeLastSet = new long[16];
    protected long[] timeLastUnset = new long[16];

    public void on(Enum<?> slot) {
        this.on(slot.ordinal());
    }

    public void on(int slot) {
        this.set(slot, true);
    }

    public void off(Enum<?> slot) {
        this.off(slot.ordinal());
    }

    public void off(int slot) {
        this.set(slot, false);
    }

    public void set(Enum<?> slot, boolean bool) {
        this.set(slot.ordinal(), bool);
    }

    public void toggle(int slot) {
        this.set(slot, !this.get(slot));
    }

    public void toggle(Enum<?> slot) {
        this.toggle(slot.ordinal());
    }

    public Set<Integer> getActiveSlots() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = 0; i < 16; ++i) {
            if (!this.get(i)) continue;
            set.add(i);
        }
        return set;
    }

    public void set(int slot, boolean bool) {
        short newVal = ByteUtils.set(this.value, slot, bool);
        if (newVal != this.value) {
            if (bool) {
                this.timeLastSet[slot] = 0L;
            } else {
                this.timeLastUnset[slot] = 0L;
            }
            this.markDirty();
        }
        this.value = newVal;
    }

    public int ticksSinceSet(IOpenModsProxy proxy, World world, Enum<?> slot) {
        return this.ticksSinceSet(proxy, world, slot.ordinal());
    }

    public int ticksSinceSet(IOpenModsProxy proxy, World world, int slot) {
        return (int)(proxy.getTicks(world) - this.timeLastSet[slot]);
    }

    public int ticksSinceUnset(IOpenModsProxy proxy, World world, Enum<?> slot) {
        return this.ticksSinceUnset(proxy, world, slot.ordinal());
    }

    public int ticksSinceUnset(IOpenModsProxy proxy, World world, int slot) {
        return (int)(proxy.getTicks(world) - this.timeLastUnset[slot]);
    }

    public boolean get(Enum<?> slot) {
        return this.get(slot.ordinal());
    }

    public boolean get(int slot) {
        return ByteUtils.get(this.value, slot);
    }

    public boolean hasSlotChanged(Enum<?> slot) {
        return this.hasSlotChanged(slot.ordinal());
    }

    public boolean hasSlotChanged(int slot) {
        return ByteUtils.get(this.value, slot) != ByteUtils.get(this.previousValue, slot);
    }

    @Override
    public void markClean() {
        this.previousValue = this.value;
        this.dirty = false;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        this.value = stream.readShort();
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        stream.writeShort(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74777_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74765_d(name);
    }

    @Override
    public void resetChangeTimer(World world) {
        super.resetChangeTimer(world);
        long time = OpenMods.proxy.getTicks(world);
        for (int i = 0; i < this.timeLastSet.length; ++i) {
            if (!this.hasSlotChanged(i)) continue;
            if (this.get(i)) {
                this.timeLastSet[i] = time;
                continue;
            }
            this.timeLastUnset[i] = time;
        }
    }
}

