/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableIntArray
extends SyncableObjectBase {
    private int[] value;

    public SyncableIntArray(int[] value) {
        this.value = value;
    }

    public SyncableIntArray() {
        this(new int[0]);
    }

    public void setValue(int[] newValue) {
        if (!Arrays.equals(this.value, newValue)) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public void setValue(int offset, int newValue) {
        if (this.value[offset] != newValue) {
            this.value[offset] = newValue;
            this.markDirty();
        }
    }

    public int getValue(int offset) {
        return this.value[offset];
    }

    public int[] getValue() {
        return this.value;
    }

    public int size() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        int length = stream.readInt();
        this.value = new int[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = stream.readInt();
        }
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        stream.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            stream.writeInt(this.value[i]);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74783_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74759_k(name);
    }

    public void clear() {
        this.value = new int[0];
        this.markDirty();
    }
}

