/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.IInventoryProvider;
import openmods.utils.Coord;
import openmods.utils.InventoryUtils;

public class BlockUtils {
    public static final ForgeDirection DEFAULT_BLOCK_DIRECTION = ForgeDirection.WEST;

    public static ForgeDirection get2dOrientation(EntityLivingBase entity) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (l) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.SOUTH;
    }

    public static float getRotationFromDirection(ForgeDirection direction) {
        switch (direction) {
            case NORTH: {
                return 0.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case DOWN: {
                return -90.0f;
            }
            case UP: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    public static ForgeDirection get3dOrientation(EntityLivingBase entity) {
        if (entity.field_70125_A > 45.5f) {
            return ForgeDirection.DOWN;
        }
        if (entity.field_70125_A < -45.5f) {
            return ForgeDirection.UP;
        }
        return BlockUtils.get2dOrientation(entity);
    }

    public static EntityItem dropItemStackInWorld(World worldObj, double x, double y, double z, ItemStack stack) {
        float f = 0.7f;
        float d0 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d1 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        float d2 = worldObj.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
        EntityItem entityitem = new EntityItem(worldObj, x + (double)d0, y + (double)d1, z + (double)d2, stack);
        entityitem.field_70293_c = 10;
        if (stack.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        worldObj.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public static EntityItem ejectItemInDirection(World world, double x, double y, double z, ForgeDirection direction, ItemStack stack) {
        EntityItem item = BlockUtils.dropItemStackInWorld(world, x, y, z, stack);
        item.field_70159_w = (float)direction.offsetX / 5.0f;
        item.field_70181_x = (float)direction.offsetY / 5.0f;
        item.field_70179_y = (float)direction.offsetZ / 5.0f;
        return item;
    }

    public static boolean getTileInventoryDrops(TileEntity tileEntity, List<ItemStack> drops) {
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof IInventory) {
            drops.addAll(InventoryUtils.getInventoryContents((IInventory)tileEntity));
            return true;
        }
        if (tileEntity instanceof IInventoryProvider) {
            drops.addAll(InventoryUtils.getInventoryContents(((IInventoryProvider)tileEntity).getInventory()));
            return true;
        }
        return false;
    }

    public static void dropInventory(IInventory inventory, World world, double x, double y, double z) {
        if (inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null) continue;
            BlockUtils.dropItemStackInWorld(world, x, y, z, itemStack);
        }
    }

    public static void dropInventory(IInventory inventory, World world, int x, int y, int z) {
        BlockUtils.dropInventory(inventory, world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
    }

    public static TileEntity getTileInDirection(TileEntity tile, ForgeDirection direction) {
        int targetX = tile.field_70329_l + direction.offsetX;
        int targetY = tile.field_70330_m + direction.offsetY;
        int targetZ = tile.field_70327_n + direction.offsetZ;
        return tile.field_70331_k.func_72796_p(targetX, targetY, targetZ);
    }

    public static TileEntity getTileInDirection(World world, Coord coord, ForgeDirection direction) {
        int targetX = coord.x + direction.offsetX;
        int targetY = coord.y + direction.offsetY;
        int targetZ = coord.z + direction.offsetZ;
        return world.func_72796_p(targetX, targetY, targetZ);
    }

    public static int getFirstNonAirBlockFromTop(World world, int x, int z) {
        int y;
        for (y = world.func_72940_L(); world.func_72799_c(x, y - 1, z) && y > 0; --y) {
        }
        return y;
    }

    public static boolean isBlockHit(MovingObjectPosition mop, TileEntity tile) {
        if (tile == null) {
            return false;
        }
        return BlockUtils.isBlockHit(mop, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
    }

    public static boolean isBlockHit(MovingObjectPosition mop, int x, int y, int z) {
        if (mop == null) {
            return false;
        }
        return mop.field_72311_b == x && mop.field_72312_c == y && mop.field_72309_d == z;
    }
}

