/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class ColorUtils {
    public static final int BLACK = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BROWN = 3;
    public static final int BLUE = 4;
    public static final int PURPLE = 5;
    public static final int CYAN = 6;
    public static final int LIGHT_GRAY = 7;
    public static final int GRAY = 8;
    public static final int PINK = 9;
    public static final int LIME = 10;
    public static final int YELLOW = 11;
    public static final int LIGHT_BLUE = 12;
    public static final int MAGENTA = 13;
    public static final int ORANGE = 14;
    public static final int WHITE = 15;
    private static final List<ColorMeta> COLORS = Lists.newArrayList();
    private static final Map<String, ColorMeta> COLORS_BY_ORE_NAME = Maps.newHashMap();
    private static final Map<String, ColorMeta> COLORS_BY_NAME = Maps.newHashMap();
    private static final Map<Integer, ColorMeta> COLORS_BY_ORE_ID = Maps.newHashMap();
    private static final Map<Integer, ColorMeta> COLORS_BY_BITMASK = Maps.newHashMap();
    private static final Map<Integer, ColorMeta> COLORS_BY_VANILLA = Maps.newHashMap();

    public static ItemStack createDyedWool(int color) {
        return ColorUtils.createDyedBlock(Block.field_72101_ab, color);
    }

    public static ItemStack createStainedClay(int color) {
        return ColorUtils.createDyedBlock(Block.field_111039_cA, color);
    }

    public static ItemStack createDyedCarpet(int color) {
        return ColorUtils.createDyedBlock(Block.field_111031_cC, color);
    }

    public static ItemStack createDyedBlock(Block block, int color) {
        int blockColor = BlockColored.func_72238_e_((int)color);
        return new ItemStack(block, 1, blockColor);
    }

    private static void addEntry(String name, int colorValue, int vanillaId) {
        String oreName = "dye" + WordUtils.capitalize((String)name);
        int oreId = OreDictionary.getOreID((String)oreName);
        name = name.toLowerCase();
        ColorMeta color = new ColorMeta(colorValue, vanillaId, oreId, name, oreName);
        COLORS.add(color);
        COLORS_BY_NAME.put(name, color);
        COLORS_BY_ORE_NAME.put(oreName, color);
        COLORS_BY_ORE_ID.put(oreId, color);
        COLORS_BY_BITMASK.put(color.bitmask, color);
        COLORS_BY_VANILLA.put(vanillaId, color);
    }

    public static ColorMeta stackToColor(ItemStack stack) {
        int oreId = OreDictionary.getOreID((ItemStack)stack);
        if (oreId < 0) {
            return null;
        }
        return COLORS_BY_ORE_ID.get(oreId);
    }

    public static ColorMeta oreIdToColor(int oreId) {
        return COLORS_BY_ORE_ID.get(oreId);
    }

    public static ColorMeta oreNameToColor(String oreName) {
        return COLORS_BY_ORE_NAME.get(oreName);
    }

    public static ColorMeta nameToColor(String name) {
        return COLORS_BY_NAME.get(name.toLowerCase());
    }

    public static ColorMeta bitmaskToColor(int bitmask) {
        return COLORS_BY_BITMASK.get(bitmask);
    }

    public static ColorMeta vanillaToColor(int vanillaId) {
        return COLORS_BY_VANILLA.get(vanillaId);
    }

    public static Collection<ColorMeta> getAllColors() {
        return Collections.unmodifiableCollection(COLORS);
    }

    public static int bitmaskToVanilla(int color) {
        int low;
        int high = Integer.numberOfLeadingZeros(color);
        Preconditions.checkArgument((high == 31 - (low = Integer.numberOfTrailingZeros(color)) && low <= 16 ? 1 : 0) != 0, (String)"Invalid color value: %sb", (Object[])new Object[]{Integer.toBinaryString(color)});
        return low;
    }

    static {
        ColorUtils.addEntry("black", 0x1E1B1B, 0);
        ColorUtils.addEntry("red", 11743532, 1);
        ColorUtils.addEntry("green", 3887386, 2);
        ColorUtils.addEntry("brown", 5320730, 3);
        ColorUtils.addEntry("blue", 2437522, 4);
        ColorUtils.addEntry("purple", 8073150, 5);
        ColorUtils.addEntry("cyan", 2651799, 6);
        ColorUtils.addEntry("lightGray", 0xABABAB, 7);
        ColorUtils.addEntry("gray", 0x434343, 8);
        ColorUtils.addEntry("pink", 14188952, 9);
        ColorUtils.addEntry("lime", 4312372, 10);
        ColorUtils.addEntry("yellow", 14602026, 11);
        ColorUtils.addEntry("lightBlue", 6719955, 12);
        ColorUtils.addEntry("magenta", 12801229, 13);
        ColorUtils.addEntry("orange", 15435844, 14);
        ColorUtils.addEntry("white", 0xF0F0F0, 15);
    }

    public static class CYMK {
        private float cyan;
        private float yellow;
        private float magenta;
        private float key;

        public CYMK(float c, float y, float m, float k) {
            this.cyan = c;
            this.yellow = y;
            this.magenta = m;
            this.key = k;
        }

        public float getCyan() {
            return this.cyan;
        }

        public void setCyan(float cyan) {
            this.cyan = cyan;
        }

        public float getYellow() {
            return this.yellow;
        }

        public void setYellow(float yellow) {
            this.yellow = yellow;
        }

        public float getMagenta() {
            return this.magenta;
        }

        public void setMagenta(float magenta) {
            this.magenta = magenta;
        }

        public float getKey() {
            return this.key;
        }

        public void setKey(float key) {
            this.key = key;
        }
    }

    public static class RGB {
        public int r;
        public int g;
        public int b;

        public RGB(float r, float g, float b) {
            this.r = (int)(r * 255.0f) & 0xFF;
            this.g = (int)(g * 255.0f) & 0xFF;
            this.b = (int)(b * 255.0f) & 0xFF;
        }

        public RGB(int r, int g, int b) {
            this.r = r & 0xFF;
            this.g = g & 0xFF;
            this.b = b & 0xFF;
        }

        public RGB(int color) {
            this((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
        }

        public RGB() {
        }

        public void setColor(int color) {
            this.r = (color & 0xFF0000) >> 16;
            this.g = (color & 0xFF00) >> 8;
            this.b = color & 0xFF;
        }

        public int getColor() {
            return this.r << 16 | this.g << 8 | this.b;
        }

        public float getR() {
            return (float)this.r / 255.0f;
        }

        public float getG() {
            return (float)this.g / 255.0f;
        }

        public float getB() {
            return (float)this.b / 255.0f;
        }

        public RGB interpolate(RGB other, double amount) {
            int iPolR = (int)((double)this.r * (1.0 - amount) + (double)other.r * amount);
            int iPolG = (int)((double)this.g * (1.0 - amount) + (double)other.g * amount);
            int iPolB = (int)((double)this.b * (1.0 - amount) + (double)other.b * amount);
            return new RGB(iPolR, iPolG, iPolB);
        }

        public CYMK toCYMK() {
            float cyan = 1.0f - (float)this.r / 255.0f;
            float magenta = 1.0f - (float)this.g / 255.0f;
            float yellow = 1.0f - (float)this.b / 255.0f;
            float K = 1.0f;
            if (cyan < K) {
                K = cyan;
            }
            if (magenta < K) {
                K = magenta;
            }
            if (yellow < K) {
                K = yellow;
            }
            if (K == 1.0f) {
                cyan = 0.0f;
                magenta = 0.0f;
                yellow = 0.0f;
            } else {
                cyan = (cyan - K) / (1.0f - K);
                magenta = (magenta - K) / (1.0f - K);
                yellow = (yellow - K) / (1.0f - K);
            }
            return new CYMK(cyan, yellow, magenta, K);
        }
    }

    public static class ColorMeta {
        public final int rgb;
        public final int vanillaId;
        public final int oreId;
        public final int bitmask;
        public final String oreName;
        public final String name;

        public ColorMeta(int rgb, int vanillaId, int oreId, String name, String oreName) {
            this.rgb = rgb;
            this.vanillaId = vanillaId;
            this.oreId = oreId;
            this.oreName = oreName;
            this.name = name;
            this.bitmask = 1 << vanillaId;
        }
    }
}

