/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;

public class CommandUtils {
    public static List<String> filterPrefixes(String prefix, Collection<String> proposals) {
        prefix = prefix.toLowerCase();
        ArrayList result = Lists.newArrayList();
        for (String s : proposals) {
            if (!s.startsWith(prefix)) continue;
            result.add(s);
        }
        return result;
    }

    public static List<String> getPlayerNames() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null) {
            return ImmutableList.copyOf((Object[])server.func_71213_z());
        }
        return ImmutableList.of();
    }

    public static List<String> fiterPlayerNames(String prefix) {
        return CommandUtils.filterPrefixes(prefix, CommandUtils.getPlayerNames());
    }

    public static void respond(ICommandSender sender, String format) {
        sender.func_70006_a(ChatMessageComponent.func_111077_e((String)format));
    }

    public static void respond(ICommandSender sender, String format, Object ... args) {
        sender.func_70006_a(ChatMessageComponent.func_111082_b((String)format, (Object[])args));
    }

    public static CommandException error(String format, Object ... args) {
        throw new CommandException(format, args);
    }

    public static EntityPlayerMP getPlayer(ICommandSender sender, String playerName) {
        EntityPlayerMP player = PlayerSelector.func_82386_a((ICommandSender)sender, (String)playerName);
        if (player != null) {
            return player;
        }
        player = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(playerName);
        if (player != null) {
            return player;
        }
        throw new PlayerNotFoundException();
    }
}

