/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EnchantmentUtils {
    public static final int XP_PER_BOTTLE = 8;
    public static final int RATIO = 20;
    public static final int LIQUID_PER_XP_BOTTLE = 160;

    public static int calcEnchantability(ItemStack itemStack, int power, boolean max) {
        Item item = itemStack.func_77973_b();
        int k = item.func_77619_b();
        if (k <= 0) {
            return 0;
        }
        if (power > 15) {
            power = 15;
        }
        int l = (max ? 7 : 0) + 1 + (power >> 1) + (max ? power : 0);
        return max ? Math.max(l, power * 2) : Math.max(l / 3, 1);
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)EnchantmentUtils.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = EnchantmentUtils.getPlayerXP(player) + amount;
        player.field_71068_ca = EnchantmentUtils.getLevelForExperience(experience);
        int expForLevel = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static boolean enchantItem(ItemStack itemstack, int level, Random rand) {
        if (itemstack != null) {
            boolean flag;
            List list = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)itemstack, (int)level);
            boolean bl = flag = itemstack.field_77993_c == Item.field_77760_aL.field_77779_bT;
            if (list != null) {
                if (flag) {
                    itemstack.field_77993_c = Item.field_92105_bW.field_77779_bT;
                }
                int j = flag ? rand.nextInt(list.size()) : -1;
                for (int k = 0; k < list.size(); ++k) {
                    EnchantmentData enchantmentdata = (EnchantmentData)list.get(k);
                    if (flag && k != j) continue;
                    if (flag) {
                        Item.field_92105_bW.func_92115_a(itemstack, enchantmentdata);
                        continue;
                    }
                    itemstack.func_77966_a(enchantmentdata.field_76302_b, enchantmentdata.field_76303_c);
                }
            }
            return true;
        }
        return false;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = EnchantmentUtils.getLevelForExperience(level);
        int nextXP = EnchantmentUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (EnchantmentUtils.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static double getPower(World worldObj, int xCoord, int yCoord, int zCoord) {
        float power = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0 || !worldObj.func_72799_c(xCoord + k, yCoord, zCoord + j) || !worldObj.func_72799_c(xCoord + k, yCoord + 1, zCoord + j)) continue;
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)(xCoord + k * 2), (int)yCoord, (int)(zCoord + j * 2));
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)(xCoord + k * 2), (int)(yCoord + 1), (int)(zCoord + j * 2));
                if (k == 0 || j == 0) continue;
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)(xCoord + k * 2), (int)yCoord, (int)(zCoord + j));
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)(xCoord + k * 2), (int)(yCoord + 1), (int)(zCoord + j));
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)(xCoord + k), (int)yCoord, (int)(zCoord + j * 2));
                power += ForgeHooks.getEnchantPower((World)worldObj, (int)(xCoord + k), (int)(yCoord + 1), (int)(zCoord + j * 2));
            }
        }
        return power;
    }

    public static int liquidToXPRatio(int liquid) {
        return liquid / 20;
    }

    public static int XPToLiquidRatio(int xp) {
        return xp * 20;
    }

    public static int getLiquidForLevel(int level) {
        return EnchantmentUtils.XPToLiquidRatio(EnchantmentUtils.getExperienceForLevel(level));
    }

    public static void addAllBooks(Enchantment enchantment, List<ItemStack> items) {
        for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
            items.add(Item.field_92105_bW.func_92111_a(new EnchantmentData(enchantment, i)));
        }
    }
}

