/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.util.ChatAllowedCharacters;
import openmods.OpenMods;

public class FontSizeChecker {
    private static FontSizeChecker instance = null;
    private int[] charWidth = new int[256];

    public static FontSizeChecker getInstance() {
        if (instance == null) {
            instance = new FontSizeChecker("textures/font/ascii.png");
        }
        return instance;
    }

    private FontSizeChecker(String textureFile) {
        this.readFontTexture(textureFile);
    }

    private void readFontTexture(String par1Str) {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(OpenMods.class.getResourceAsStream(par1Str));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] aint = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, aint, 0, i);
        for (int k = 0; k < 256; ++k) {
            int j1;
            int l = k % 16;
            int i1 = k / 16;
            for (j1 = 7; j1 >= 0; --j1) {
                int k1 = l * 8 + j1;
                boolean flag = true;
                for (int l1 = 0; l1 < 8 && flag; ++l1) {
                    int i2 = (i1 * 8 + l1) * i;
                    int j2 = aint[k1 + i2] & 0xFF;
                    if (j2 <= 0) continue;
                    flag = false;
                }
                if (!flag) break;
            }
            if (k == 32) {
                j1 = 2;
            }
            this.charWidth[k] = j1 + 2;
        }
    }

    public int getCharWidth(char par1) {
        if (par1 == '\u00a7') {
            return -1;
        }
        if (par1 == ' ') {
            return 4;
        }
        int i = ChatAllowedCharacters.field_71568_a.indexOf(par1);
        if (i != -1) {
            return this.charWidth[i + 32];
        }
        return 8;
    }

    public int getStringWidth(String par1Str) {
        if (par1Str == null) {
            return 0;
        }
        int i = 0;
        boolean flag = false;
        for (int j = 0; j < par1Str.length(); ++j) {
            char c0 = par1Str.charAt(j);
            int k = this.getCharWidth(c0);
            if (k < 0 && j < par1Str.length() - 1) {
                if ((c0 = par1Str.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0;
            }
            i += k;
            if (!flag) continue;
            ++i;
        }
        return i;
    }

    public int getStringHeight(String par1Str) {
        return par1Str == null ? 0 : 8;
    }
}

