/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tmechworks.blocks.logic.SignalTerminalLogic;
import tmechworks.client.block.SignalTerminalRender;
import tmechworks.common.MechContent;
import tmechworks.lib.TMechworksRegistry;

public class SignalTerminal
extends Block
implements ITileEntityProvider {
    public static int HITBOXES = 13;
    public static int[] sideBoxMapping = new int[]{-1, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5};
    public Icon[] icons;
    public Icon[] channelIcons;
    public String[] textureNames = new String[]{"signalbus"};
    public String[] channelTextureNames = new String[]{"white", "orange", "magenta", "lightblue", "yellow", "lime", "pink", "gray", "lightgray", "cyan", "purple", "blue", "brown", "green", "red", "black"};

    public SignalTerminal(int par1) {
        super(par1, Material.field_76265_p);
        this.func_71848_c(0.1f);
        this.func_71894_b(1.0f);
        this.func_71884_a(field_71977_i);
        this.func_71849_a(TMechworksRegistry.Mechworks);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        return this.icons[0];
    }

    public Icon getChannelIcon(int channel) {
        if (channel < 0 || channel >= this.channelIcons.length) {
            return this.channelIcons[0];
        }
        return this.channelIcons[channel];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        int i;
        this.icons = new Icon[this.textureNames.length];
        for (i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tmechworks:" + this.textureNames[i]);
        }
        this.channelIcons = new Icon[this.channelTextureNames.length];
        for (i = 0; i < this.channelIcons.length; ++i) {
            this.channelIcons[i] = iconRegister.func_94245_a("tmechworks:glass/stainedglass_" + this.channelTextureNames[i]);
        }
    }

    public AxisAlignedBB func_71872_e(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.func_72796_p(x, y, z);
        return te != null && te instanceof SignalTerminalLogic && ((SignalTerminalLogic)te).getConnectedSides()[side.ordinal()] != -1;
    }

    public int func_71857_b() {
        return SignalTerminalRender.renderID;
    }

    public int func_71859_p_(World par1World) {
        return 1;
    }

    public boolean func_71930_b(World world, int x, int y, int z) {
        return world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST) || world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST) || world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH) || world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH) || world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP) || world.isBlockSolidOnSide(x, y + 1, z, ForgeDirection.DOWN);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        float minX = 1.0f;
        float minY = 1.0f;
        float minZ = 1.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float maxZ = 0.0f;
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            for (AxisAlignedBB aabb : SignalTerminal.getBoxes((SignalTerminalLogic)te)) {
                if (aabb == null) continue;
                minX = Math.min(minX, (float)aabb.field_72340_a);
                minY = Math.min(minY, (float)aabb.field_72338_b);
                minZ = Math.min(minZ, (float)aabb.field_72339_c);
                maxX = Math.max(maxX, (float)aabb.field_72336_d);
                maxY = Math.max(maxY, (float)aabb.field_72337_e);
                maxZ = Math.max(maxZ, (float)aabb.field_72334_f);
            }
            this.func_71905_a(minX, minY, minZ, maxX, maxY, maxZ);
        } else {
            this.func_71905_a(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
        }
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST) || world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST) || world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH) || world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH) || world.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP) || world.isBlockSolidOnSide(x, y + 1, z, ForgeDirection.DOWN);
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB collisionTest, List collisionBoxList, Entity entity) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            for (AxisAlignedBB aabb : SignalTerminal.getBoxes((SignalTerminalLogic)te)) {
                if (aabb == null) continue;
                aabb = AxisAlignedBB.func_72330_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
                aabb.field_72340_a += (double)x;
                aabb.field_72338_b += (double)y;
                aabb.field_72339_c += (double)z;
                aabb.field_72336_d += (double)x;
                aabb.field_72337_e += (double)y;
                aabb.field_72334_f += (double)z;
                if (!collisionTest.func_72326_a(aabb)) continue;
                collisionBoxList.add(aabb);
            }
        } else {
            super.func_71871_a(world, x, y, z, collisionTest, collisionBoxList, entity);
        }
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int localSide) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            return ((SignalTerminalLogic)te).isProvidingWeakPower(localSide);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int localSide) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            return ((SignalTerminalLogic)te).isProvidingStrongPower(localSide);
        }
        return 0;
    }

    public boolean func_71853_i() {
        return true;
    }

    public TileEntity func_72274_a(World world) {
        return new SignalTerminalLogic();
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborID) {
        super.func_71863_a(world, x, y, z, neighborID);
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            ((SignalTerminalLogic)te).onNeighborBlockChange();
        }
    }

    private static AxisAlignedBB[] getBoxes(SignalTerminalLogic logic) {
        byte[] connected = logic.getConnectedSides();
        AxisAlignedBB[] parts = new AxisAlignedBB[HITBOXES];
        parts[0] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.center_min, (double)TerminalGeometry.center_min, (double)TerminalGeometry.center_min, (double)TerminalGeometry.center_max, (double)TerminalGeometry.center_max, (double)TerminalGeometry.center_max);
        if (connected[ForgeDirection.DOWN.ordinal()] != -1) {
            parts[1] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_low_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_low_max, (double)TerminalGeometry.plate_width_max);
            parts[2] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_low_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_low_max, (double)TerminalGeometry.channel_width_max);
        }
        if (connected[ForgeDirection.UP.ordinal()] != -1) {
            parts[3] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_high_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_high_max, (double)TerminalGeometry.plate_width_max);
            parts[4] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_high_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_high_max, (double)TerminalGeometry.channel_width_max);
        }
        if (connected[ForgeDirection.NORTH.ordinal()] != -1) {
            parts[5] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_high_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_high_max);
            parts[6] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_high_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_high_max);
        }
        if (connected[ForgeDirection.SOUTH.ordinal()] != -1) {
            parts[7] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_low_min, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_low_max);
            parts[8] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_low_min, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_low_max);
        }
        if (connected[ForgeDirection.WEST.ordinal()] != -1) {
            parts[9] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.plate_low_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_low_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max);
            parts[10] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.channel_low_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_low_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max);
        }
        if (connected[ForgeDirection.EAST.ordinal()] != -1) {
            parts[11] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.plate_high_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_width_min, (double)TerminalGeometry.plate_high_max, (double)TerminalGeometry.plate_width_max, (double)TerminalGeometry.plate_width_max);
            parts[12] = AxisAlignedBB.func_72330_a((double)TerminalGeometry.channel_high_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_width_min, (double)TerminalGeometry.channel_high_max, (double)TerminalGeometry.channel_width_max, (double)TerminalGeometry.channel_width_max);
        }
        return parts;
    }

    private static int closestClicked(EntityPlayer player, double reachDistance, SignalTerminalLogic terminal, AxisAlignedBB[] parts) {
        int closest = -1;
        Vec3 playerPosition = Vec3.func_72443_a((double)(player.field_70165_t - (double)terminal.field_70329_l), (double)(player.field_70163_u - (double)terminal.field_70330_m + (double)player.func_70047_e()), (double)(player.field_70161_v - (double)terminal.field_70327_n));
        Vec3 playerLook = player.func_70040_Z();
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance));
        double closestCalc = Double.MAX_VALUE;
        double hitDistance = 0.0;
        for (int i = 0; i < parts.length; ++i) {
            MovingObjectPosition hit;
            if (parts[i] == null || (hit = parts[i].func_72327_a(playerPosition, playerViewOffset)) == null || !((hitDistance = playerPosition.func_72438_d(hit.field_72307_f)) < closestCalc)) continue;
            closestCalc = hitDistance;
            closest = i;
        }
        return closest;
    }

    public boolean func_71903_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity te = par1World.func_72796_p(par2, par3, par4);
        if (!par1World.field_72995_K && te != null && te instanceof SignalTerminalLogic) {
            int boxHit;
            if (!par1World.field_72995_K) {
                par1World.func_72845_h(par2, par3, par4);
            }
            if ((boxHit = SignalTerminal.closestClicked(par5EntityPlayer, 3.0, (SignalTerminalLogic)te, SignalTerminal.getBoxes((SignalTerminalLogic)te))) < 0 || boxHit >= HITBOXES) {
                return false;
            }
            if (boxHit == 0) {
                return false;
            }
            int side = sideBoxMapping[boxHit];
            if (side < 0 || side >= 6) {
                return false;
            }
            if (par5EntityPlayer.func_70093_af()) {
                ((SignalTerminalLogic)te).prevChannel(side);
            } else {
                ((SignalTerminalLogic)te).nextChannel(side);
            }
        }
        return false;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            NBTTagCompound data = itemStack.field_77990_d;
            if (data != null && data.func_74764_b("connectedSide")) {
                ((SignalTerminalLogic)te).addPendingSide(data.func_74762_e("connectedSide"));
                itemStack.field_77990_d = null;
            }
            ((SignalTerminalLogic)te).connectPending();
        }
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_71852_a(World world, int x, int y, int z, int id, int meta) {
        int dropWire = 0;
        Random rand = new Random();
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof SignalTerminalLogic) {
            float offset;
            EntityItem entityitem;
            float jumpZ;
            float jumpY;
            float jumpX;
            ItemStack tempStack;
            int dropTerm = ((SignalTerminalLogic)te).getDroppedTerminals();
            dropWire = ((SignalTerminalLogic)te).getDroppedWire();
            if (dropTerm > 0) {
                tempStack = new ItemStack(MechContent.signalTerminal.field_71990_ca, dropTerm, 0);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.field_70159_w = (float)rand.nextGaussian() * offset;
                entityitem.field_70181_x = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.field_70179_y = (float)rand.nextGaussian() * offset;
                world.func_72838_d((Entity)entityitem);
            }
            if (dropWire > 0) {
                tempStack = new ItemStack(MechContent.lengthWire, dropWire);
                jumpX = rand.nextFloat() * 0.8f + 0.1f;
                jumpY = rand.nextFloat() * 0.8f + 0.1f;
                jumpZ = rand.nextFloat() * 0.8f + 0.1f;
                entityitem = new EntityItem(world, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), tempStack);
                offset = 0.05f;
                entityitem.field_70159_w = (float)rand.nextGaussian() * offset;
                entityitem.field_70181_x = (float)rand.nextGaussian() * offset + 0.2f;
                entityitem.field_70179_y = (float)rand.nextGaussian() * offset;
                world.func_72838_d((Entity)entityitem);
            }
            ((SignalTerminalLogic)te).notifyBreak();
        }
        super.func_71852_a(world, x, y, z, id, meta);
    }

    public static class TerminalGeometry {
        public static float plate_width_min = 0.25f;
        public static float plate_width_max = 0.75f;
        public static float plate_low_max = 0.15f;
        public static float plate_high_max = 1.0f;
        public static float plate_low_min = 0.0f;
        public static float plate_high_min = 1.0f - plate_low_max;
        public static float center_min = 0.375f;
        public static float center_max = 0.625f;
        public static float channel_width_min = 0.375f;
        public static float channel_width_max = 0.625f;
        public static float channel_low_max = center_min;
        public static float channel_high_max = plate_high_min;
        public static float channel_low_min = plate_low_max;
        public static float channel_high_min = center_max;
    }
}

