/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tmechworks.blocks.SignalTerminal;
import tmechworks.blocks.logic.SignalBusLogic;
import tmechworks.common.MechContent;
import tmechworks.lib.signal.ISignalTransceiver;
import tmechworks.lib.util.CoordTuple;

public class SignalTerminalLogic
extends TileEntity
implements ISignalTransceiver {
    private byte[] connectedSides = new byte[6];
    private byte[] receivingSides = new byte[6];
    private byte[] sideChannel = new byte[6];
    private boolean forceUpdateSide;
    private boolean neighborChanged;
    private byte[] cachedSouthboundSignals;
    private int pendingSide = -1;
    private CoordTuple signalBus = null;
    private boolean doUpdate = false;
    private boolean isRegistered = false;

    public SignalTerminalLogic() {
        for (int i = 0; i < 6; ++i) {
            this.connectedSides[i] = -1;
            this.receivingSides[i] = -1;
            this.sideChannel[i] = 0;
            this.forceUpdateSide = false;
        }
        this.neighborChanged = false;
    }

    private void tryRegister() {
        boolean wasRegistered = this.isRegistered;
        if (!(this.field_70331_k instanceof World)) {
            return;
        }
        if (!(this.signalBus instanceof CoordTuple)) {
            return;
        }
        TileEntity te = this.field_70331_k.func_72796_p(this.signalBus.x, this.signalBus.y, this.signalBus.z);
        if (!(te instanceof SignalBusLogic)) {
            return;
        }
        this.isRegistered = ((SignalBusLogic)te).registerTerminal(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, false);
        if (this.isRegistered != wasRegistered) {
            if (this.isRegistered) {
                this.doUpdate = true;
            } else {
                this.signalBus = null;
                this.doUpdate = true;
            }
        }
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.sideChannel = data.func_74770_j("sideChannel");
        this.receivingSides = data.func_74770_j("receivingSides");
        this.connectedSides = data.func_74770_j("connectedSides");
        if (this.sideChannel.length != 6) {
            this.sideChannel = new byte[]{0, 0, 0, 0, 0, 0};
        }
        if (this.receivingSides.length != 6) {
            this.receivingSides = new byte[]{-1, -1, -1, -1, -1, -1};
        }
        if (this.connectedSides.length != 6) {
            this.connectedSides = new byte[]{-1, -1, -1, -1, -1, -1};
        }
        int tX = data.func_74762_e("BusX");
        int tY = data.func_74762_e("BusY");
        int tZ = data.func_74762_e("BusZ");
        this.signalBus = tX == this.field_70329_l && tY == this.field_70330_m && tZ == this.field_70327_n ? null : new CoordTuple(tX, tY, tZ);
        if (!this.isRegistered) {
            this.tryRegister();
        }
        this.doUpdate = true;
    }

    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74773_a("sideChannel", this.sideChannel);
        data.func_74773_a("receivingSides", this.receivingSides);
        data.func_74773_a("connectedSides", this.connectedSides);
        if (this.signalBus != null) {
            data.func_74768_a("BusX", this.signalBus.x);
            data.func_74768_a("BusY", this.signalBus.y);
            data.func_74768_a("BusZ", this.signalBus.z);
        } else {
            data.func_74768_a("BusX", this.field_70329_l);
            data.func_74768_a("BusY", this.field_70330_m);
            data.func_74768_a("BusZ", this.field_70327_n);
        }
    }

    public void func_70316_g() {
        if (this.pendingSide >= 0 && this.pendingSide < 6 && this.connectedSides[this.pendingSide] == -1) {
            this.connectedSides[this.pendingSide] = 0;
            this.pendingSide = -1;
            this.forceUpdateSide = true;
        }
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.forceUpdateSide || this.neighborChanged) {
            this.checkNeighbors();
            this.neighborChanged = false;
            this.forceUpdateSide = false;
        }
        if (!this.doUpdate) {
            return;
        }
        if (!this.isRegistered) {
            this.tryRegister();
        }
        if (this.cachedSouthboundSignals != null) {
            this.processSignalUpdate(this.cachedSouthboundSignals);
        }
        this.doUpdate = false;
    }

    @Override
    public void receiveSignalUpdate(byte[] signals) {
        if (!Arrays.equals(this.cachedSouthboundSignals, signals)) {
            this.cachedSouthboundSignals = (byte[])signals.clone();
            this.doUpdate = true;
        }
    }

    private void processSignalUpdate(byte[] signals) {
        int targetX = 0;
        int targetY = 0;
        int targetZ = 0;
        for (int i = 0; i < 6; ++i) {
            int oSide;
            if (this.connectedSides[i] == -1) continue;
            byte oldValue = this.connectedSides[i];
            this.connectedSides[i] = signals[this.sideChannel[i]];
            if (oldValue == this.connectedSides[i]) continue;
            targetX = this.field_70329_l;
            targetY = this.field_70330_m;
            targetZ = this.field_70327_n;
            switch (i) {
                case 0: {
                    --targetY;
                    oSide = 1;
                    break;
                }
                case 1: {
                    ++targetY;
                    oSide = 0;
                    break;
                }
                case 2: {
                    ++targetZ;
                    oSide = 2;
                    break;
                }
                case 3: {
                    --targetZ;
                    oSide = 3;
                    break;
                }
                case 4: {
                    --targetX;
                    oSide = 5;
                    break;
                }
                case 5: {
                    ++targetX;
                    oSide = 4;
                    break;
                }
                default: {
                    oSide = 0;
                }
            }
            this.field_70331_k.func_72821_m(targetX, targetY, targetZ, MechContent.signalTerminal.field_71990_ca);
            this.field_70331_k.func_96439_d(targetX, targetY, targetZ, MechContent.signalTerminal.field_71990_ca, oSide);
        }
    }

    @Override
    public void setBusCoords(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g == this.field_70331_k.field_73011_w.field_76574_g && !world.field_72995_K && !this.field_70331_k.field_72995_K) {
            this.signalBus = new CoordTuple(x, y, z);
            world.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        this.doUpdate = true;
    }

    public int isProvidingWeakPower(int side) {
        return this.isProvidingStrongPower(side);
    }

    public int isProvidingStrongPower(int side) {
        int tside = side;
        switch (side) {
            case 0: {
                tside = 1;
                break;
            }
            case 1: {
                tside = 0;
                break;
            }
            case 2: {
                tside = 2;
                break;
            }
            case 3: {
                tside = 3;
                break;
            }
            case 4: {
                tside = 5;
                break;
            }
            case 5: {
                tside = 4;
                break;
            }
            default: {
                tside = side;
            }
        }
        if (tside >= 0 && tside < 6 && this.connectedSides[tside] > 0) {
            return this.connectedSides[tside] - 1;
        }
        return 0;
    }

    public void addPendingSide(int side) {
        this.pendingSide = side;
    }

    public void connectPending() {
        if (this.pendingSide >= 0 && this.pendingSide < 6 && this.connectedSides[this.pendingSide] == -1) {
            this.connectedSides[this.pendingSide] = 0;
        }
        this.pendingSide = -1;
        this.doUpdate = true;
    }

    public byte[] getConnectedSides() {
        return (byte[])this.connectedSides.clone();
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.func_70296_d();
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.doUpdate = true;
    }

    public static Icon getChannelIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && te instanceof SignalTerminalLogic) {
            byte channel = ((SignalTerminalLogic)te).sideChannel[side];
            return ((SignalTerminal)MechContent.signalTerminal).getChannelIcon(channel);
        }
        return ((SignalTerminal)MechContent.signalTerminal).getChannelIcon(0);
    }

    public static Icon[] getChannelIcons() {
        return ((SignalTerminal)MechContent.signalTerminal).channelIcons;
    }

    public static Icon getChannelIcon(int channel) {
        return SignalTerminalLogic.getChannelIcons()[channel];
    }

    public Icon getChannelIconFromLogic(int side) {
        return SignalTerminalLogic.getChannelIcons()[this.sideChannel[side]];
    }

    public void nextChannel(int side) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        int n = side;
        this.sideChannel[n] = (byte)(this.sideChannel[n] + 1);
        if (this.sideChannel[side] >= 16) {
            this.sideChannel[side] = 0;
        }
        this.doUpdate = true;
    }

    public void prevChannel(int side) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        int n = side;
        this.sideChannel[n] = (byte)(this.sideChannel[n] - 1);
        if (this.sideChannel[side] < 0) {
            this.sideChannel[side] = 15;
        }
        this.doUpdate = true;
    }

    public void notifyBreak() {
        if (!(this.field_70331_k instanceof World) || this.field_70331_k.field_72995_K) {
            return;
        }
        if (!(this.signalBus instanceof CoordTuple)) {
            return;
        }
        TileEntity te = this.field_70331_k.func_72796_p(this.signalBus.x, this.signalBus.y, this.signalBus.z);
        if (te == null || !(te instanceof SignalBusLogic)) {
            return;
        }
        ((SignalBusLogic)te).unregisterTerminal(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void onNeighborBlockChange() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.neighborChanged = true;
    }

    public void checkNeighbors() {
        if (this.signalBus != null && this.signalBus instanceof CoordTuple) {
            TileEntity te = this.field_70331_k.func_72796_p(this.signalBus.x, this.signalBus.y, this.signalBus.z);
            if (te instanceof SignalBusLogic) {
                ((SignalBusLogic)te).updateTransceiverSignals(new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n), this.getReceivedSignals());
            }
        } else {
            this.receiveSignalUpdate(this.getReceivedSignals());
        }
    }

    public Icon[] getSideIcons() {
        Icon[] icons = SignalTerminalLogic.getChannelIcons();
        Icon[] sideIcons = new Icon[6];
        for (int i = 0; i < 6; ++i) {
            sideIcons[i] = this.sideChannel[i] > 0 ? icons[this.sideChannel[i]] : icons[0];
        }
        return sideIcons;
    }

    public byte[] getReceivedSignals(boolean vanillaRedstoneKludge) {
        byte[] highChannel = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] offset = new int[]{0, 0, 0};
        for (int i = 0; i < 6; ++i) {
            int oSide;
            if (this.connectedSides[i] == -1) continue;
            offset[0] = 0;
            offset[1] = 0;
            offset[2] = 0;
            switch (i) {
                case 0: {
                    offset[1] = offset[1] + -1;
                    oSide = 1;
                    break;
                }
                case 1: {
                    offset[1] = offset[1] + 1;
                    oSide = 0;
                    break;
                }
                case 2: {
                    offset[2] = offset[2] + 1;
                    oSide = 3;
                    break;
                }
                case 3: {
                    offset[2] = offset[2] + -1;
                    oSide = 2;
                    break;
                }
                case 4: {
                    offset[0] = offset[0] + -1;
                    oSide = 5;
                    break;
                }
                case 5: {
                    offset[0] = offset[0] + 1;
                    oSide = 4;
                    break;
                }
                default: {
                    oSide = i;
                }
            }
            int tempStrength = 0;
            if (this.connectedSides[i] > 0) {
                byte temporarySide = this.connectedSides[i];
                this.connectedSides[i] = -1;
                tempStrength = this.field_70331_k.func_72878_l(this.field_70329_l + offset[0], this.field_70330_m + offset[1], this.field_70327_n + offset[2], oSide);
                if (tempStrength > 0 && tempStrength == temporarySide - 1) {
                    int bid = 0;
                    int power = 0;
                    int temp = 0;
                    for (int j = 0; j < 6; ++j) {
                        if (offset[0] + Facing.field_71586_b[j] == 0 && offset[1] + Facing.field_71587_c[j] == 0 && offset[2] + Facing.field_71585_d[j] == 0) continue;
                        temp = this.field_70331_k.func_72878_l(this.field_70329_l + offset[0] + Facing.field_71586_b[j], this.field_70330_m + offset[1] + Facing.field_71587_c[j], this.field_70327_n + offset[2] + Facing.field_71585_d[j], j);
                        if (temp > power && (bid = this.field_70331_k.func_72798_a(this.field_70329_l + offset[0] + Facing.field_71586_b[j], this.field_70330_m + offset[1] + Facing.field_71587_c[j], this.field_70327_n + offset[2] + Facing.field_71585_d[j])) != Block.field_72075_av.field_71990_ca) {
                            power = temp;
                        }
                        if (power == tempStrength) break;
                    }
                    tempStrength = power;
                }
                this.connectedSides[i] = temporarySide;
            } else {
                tempStrength = this.field_70331_k.func_72878_l(this.field_70329_l + offset[0], this.field_70330_m + offset[1], this.field_70327_n + offset[2], oSide);
            }
            this.receivingSides[i] = tempStrength > 0 ? (byte)(tempStrength - 1) : (byte)0;
            if (this.receivingSides[i] <= highChannel[this.sideChannel[i]]) continue;
            highChannel[this.sideChannel[i]] = this.receivingSides[i];
        }
        return highChannel;
    }

    @Override
    public int doUnregister(boolean reHoming) {
        int dropWire = 0;
        if (this.signalBus != null) {
            TileEntity te = this.field_70331_k.func_72796_p(this.signalBus.x, this.signalBus.y, this.signalBus.z);
            dropWire = Math.abs(this.field_70329_l - this.signalBus.x) + Math.abs(this.field_70330_m - this.signalBus.y) + Math.abs(this.field_70327_n - this.signalBus.z);
            if (te instanceof SignalBusLogic) {
                ((SignalBusLogic)te).unregisterTerminal(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        this.signalBus = null;
        this.receiveSignalUpdate(this.getReceivedSignals());
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return reHoming ? dropWire : 0;
    }

    @Override
    public byte[] getReceivedSignals() {
        return this.getReceivedSignals(false);
    }

    public int getDroppedTerminals() {
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.connectedSides[i] == -1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getDroppedWire() {
        int calcWire = 0;
        if (this.signalBus instanceof CoordTuple) {
            calcWire += Math.abs(this.signalBus.x - this.field_70329_l);
            calcWire += Math.abs(this.signalBus.y - this.field_70330_m);
            return calcWire += Math.abs(this.signalBus.z - this.field_70327_n);
        }
        return 0;
    }

    @Override
    public CoordTuple getBusCoords() {
        return this.signalBus;
    }
}

