/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.items.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tmechworks.blocks.logic.SignalBusLogic;
import tmechworks.common.MechContent;

public class SignalBusItem
extends ItemBlock {
    public static final String[] blockType = new String[]{"signalbus"};

    public SignalBusItem(int id) {
        super(id);
        this.field_77777_bU = 64;
        this.func_77627_a(false);
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77667_c(ItemStack itemstack) {
        int pos = MathHelper.func_76125_a((int)itemstack.func_77960_j(), (int)0, (int)(blockType.length - 1));
        return "tile." + blockType[pos];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77884_a(World world, int x, int y, int z, int side, EntityPlayer entityPlayer, ItemStack itemStack) {
        return super.func_77884_a(world, x, y, z, side, entityPlayer, itemStack) || this._canPlaceItemBlockOnSide(world, x, y, z, side);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NBTTagCompound data;
        int tmpX = x;
        int tmpY = y;
        int tmpZ = z;
        switch (side) {
            case 0: {
                --tmpY;
                break;
            }
            case 1: {
                ++tmpY;
                break;
            }
            case 2: {
                --tmpZ;
                break;
            }
            case 3: {
                ++tmpZ;
                break;
            }
            case 4: {
                --tmpX;
                break;
            }
            case 5: {
                ++tmpX;
                break;
            }
        }
        int tside = side;
        switch (side) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                tside = ForgeDirection.OPPOSITES[side];
                break;
            }
            default: {
                tside = side;
            }
        }
        stack.field_77990_d = data = new NBTTagCompound();
        data.func_74768_a("connectedSide", tside);
        if (super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ)) {
            stack.field_77990_d = null;
            return true;
        }
        if (!this._canPlaceItemBlockOnSide(world, x, y, z, side)) {
            return false;
        }
        TileEntity te = world.func_72796_p(tmpX, tmpY, tmpZ);
        ((SignalBusLogic)te).addPlacedSide(tside);
        stack.field_77990_d = null;
        --stack.field_77994_a;
        world.func_72902_n(x, y, z);
        return true;
    }

    private boolean _canPlaceItemBlockOnSide(World world, int x, int y, int z, int side) {
        int blockID = world.func_72798_a(x, y, z);
        if (blockID == Block.field_72037_aS.field_71990_ca && (world.func_72805_g(x, y, z) & 7) < 1) {
            side = 1;
        } else if (!(blockID == Block.field_71998_bu.field_71990_ca || blockID == Block.field_71962_X.field_71990_ca || blockID == Block.field_71961_Y.field_71990_ca || Block.field_71973_m[blockID] != null && Block.field_71973_m[blockID].isBlockReplaceable(world, x, y, z))) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        if (!MechContent.signalBus.func_71850_a_(world, x, y, z, side)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == this.func_77883_f()) {
            TileEntity te = world.func_72796_p(x, y, z);
            if (te == null || !(te instanceof SignalBusLogic)) {
                return false;
            }
            return ((SignalBusLogic)te).canPlaceOnSide(ForgeDirection.OPPOSITES[side]);
        }
        return false;
    }
}

