/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import tmechworks.TMechworks;
import tmechworks.blocks.logic.DrawbridgeLogic;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (packet.field_73630_a.equals("TMechworks")) {
            if (side == Side.SERVER) {
                this.handleServerPacket(packet, (EntityPlayerMP)player);
            } else {
                this.handleClientPacket(packet, (EntityPlayer)player);
            }
        }
    }

    void handleClientPacket(Packet250CustomPayload packet, EntityPlayer player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            inputStream.readByte();
        }
        catch (Exception e) {
            TMechworks.logger.warning("Failed at reading client packet for TMechworks.");
            e.printStackTrace();
        }
    }

    void handleServerPacket(Packet250CustomPayload packet, EntityPlayerMP player) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        try {
            byte packetID = inputStream.readByte();
            if (packetID == 5) {
                int dimension = inputStream.readInt();
                WorldServer world = DimensionManager.getWorld((int)dimension);
                int x = inputStream.readInt();
                int y = inputStream.readInt();
                int z = inputStream.readInt();
                TileEntity te = world.func_72796_p(x, y, z);
                byte direction = inputStream.readByte();
                if (te instanceof DrawbridgeLogic) {
                    ((DrawbridgeLogic)te).setPlacementDirection(direction);
                    te.func_70296_d();
                }
            }
        }
        catch (IOException e) {
            TMechworks.logger.warning("Failed at reading server packet for TMechworks.");
            e.printStackTrace();
        }
    }

    Entity getEntity(World world, int id) {
        for (Object o : world.field_72996_f) {
            if (((Entity)o).field_70157_k != id) continue;
            return (Entity)o;
        }
        return null;
    }
}

